﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using RayFire;

public class BombView : MonoBehaviour
{
    public Transform m_cameraTrans;//相机
    public Transform m_rootTrans;//root节点
    //public GameObject m_bombParticleObj;//炸弹粒子

    private RayfireBomb m_curBomb;//当前的炸弹
    private GameObject m_curBombEffect;//当前炸弹特效
    private bool m_bCanBePlace = true;//是否能放置炸弹
    private int m_totalChildNum = 0;//总数
    private bool m_bControlWin = true;//控制成功
    private bool m_bControlFail = true;//控制失败
    private float m_rate = 0.2f;//百分比
    private float m_rotateSpeed = 1000.0f;//旋转速度
    private float m_curRotateAngle = 0.0f;//当前旋转角度
    private float m_lastRotateAngle = 0.0f;//之前的旋转角度
    private void Awake()
    {
        m_totalChildNum = m_rootTrans.childCount;
    }
    private void Start()
    {
        GameServices.inputService.pad.onMoveVec3 += OnMove;
    }
    //移动
    void OnMove(Vector3 dir)
    {
        if (!BattleCtrl.instance.isStartBattle)
        {
            return;
        }
        m_curRotateAngle = m_cameraTrans.localEulerAngles.y;
        //向左滑
        if (dir.x > 0)
        {
            m_curRotateAngle -= Time.deltaTime* m_rotateSpeed;
        }
        //向右滑
        if (dir.x < 0)
        {
            m_curRotateAngle += Time.deltaTime* m_rotateSpeed;
        }
        m_cameraTrans.localRotation = Quaternion.Euler(0, m_curRotateAngle, 0);
    }
    //设置炸弹
    void SetBomb(RayfireBomb rayfireBomb)
    {
        //if(m_bombParticleObj)
        //{
        //    m_bombParticleObj.SetActive(false);
        //}

        m_curBomb = rayfireBomb;
        //if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelOneIndex)
        //{
        //    m_curBomb.range = 0.5f;
        //}
        //else if(BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelTwoIndex)
        //{
        //    m_curBomb.range = 1.5f;
        //}
        m_bCanBePlace = false;
    }
    //设置放置状态
    public void SetPlaceState(bool value)
    {
        m_bCanBePlace = value;
    }
    //开始炸
    public void StartBomb()
    {
        m_curBombEffect = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.bombEffectObj);
        m_curBombEffect.transform.position = m_curBomb.transform.position;
        m_curBomb?.Explode(0);
        m_curBomb.gameObject.SetActive(false);
        //回收
        PoolManager.Instance.ReturnObjectToPool(m_curBomb.gameObject);
        GameServices.timerServices.Push(this, 1.0f, delegate
        {
            PoolManager.Instance.ReturnObjectToPool(m_curBombEffect);
        });
    }
    private void OnDestroy()
    {
        if(m_curBomb)
        {
            PoolManager.Instance.ReturnObjectToPool(m_curBomb.gameObject);
        }
        if(m_curBombEffect)
        {
            PoolManager.Instance.ReturnObjectToPool(m_curBombEffect);
        }
        if (GameServices.inputService != null)
        {
            GameServices.inputService.pad.onMoveVec3 -= OnMove;
        }
    }
    private void Update()
    {
        if (!BattleCtrl.instance.isStartBattle || BattleCtrl.instance.isEndBattle)
        {
            return;
        }
        if (Input.GetMouseButtonUp(0))
        {
            if (m_lastRotateAngle == m_curRotateAngle)
            {
                Clicked();
            }
            m_lastRotateAngle = m_curRotateAngle;
        }
        //Debug.LogError(m_rootTrans.childCount + "................." + m_totalChildNum);
        if(m_rootTrans.childCount <= m_totalChildNum* m_rate && m_bControlWin)
        {
            m_bControlWin = false;
            BattleCtrl.instance.OnBattleWin();
        }
        if (BattleCtrl.instance.battleUI.IsLeftEmtryBomb && !BattleCtrl.instance.battleUI.IsBombButtonCanInteractable
            && m_rootTrans.childCount > m_totalChildNum * m_rate && m_bControlFail)
        {
            m_bControlFail = false;
            Invoke("CheckFail", 3);
        }
    }
    //检查是否失败
    void CheckFail()
    {
        if (BattleCtrl.instance.isEndBattle)
        {
            return;
        }
        BattleCtrl.instance.OnBattleFail();
    }

    void Clicked()
    {
        Ray ray = Camera.main.ScreenPointToRay(Input.mousePosition);

        RaycastHit hit = new RaycastHit();

        if (Physics.Raycast(ray, out hit))
        {
            if (hit.collider.tag == "Target" && m_bCanBePlace)
            {
                GameObject go = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.rayfireBombObj);
                go.transform.position = hit.point;
                SetBomb(go.GetComponent<RayfireBomb>());
                BattleCtrl.instance.battleUI.SetBomb();
            }
        }
    }
}
