﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using DG.Tweening;
using DG.Tweening.Core;
public class CarView : MonoBehaviour
{
    public Transform m_eggTrans;//蛋的落点位置
    public Transform m_eggParent;//所有蛋的父节点
    //public Transform m_targetParentTrans;//障碍物父节点
    [Header("Wheels")]
    [SerializeField] WheelCollider[] driveWheel;
    [Header("turn")]
    [SerializeField] WheelCollider[] turnWheel;
    [Header("curve")]
    [SerializeField] AnimationCurve motorTorque;
    [Header("centerMass")]
    [SerializeField] Transform centerOfMass;
    private float m_maxSpeed = 1.0f;//最大速度(40000)
    private float m_addSpeed = 0.25f;//加速度(10000)
    private float m_curSpeed = 0.0f;//当前速度
    public float m_maxMotorSpeed = 10000.0f;//动力最大速度(40000)
    public float m_addMotorSpeed = 2000.0f;//动力加速度(10000)
    private float m_curMotorSpeed = 0.0f;//当前动力速度
    private bool m_bControlMouseUp = false;//松手减速
    private bool m_bIsCanMove = true;//是否能开车
    private MeshCollider[] m_targetTrans;//所有目标
    private MeshCollider m_curTargetTrans;//当前抓的目标
    private Vector3 m_offset;//偏移值
    private int m_totalNum = 0;//货物总数量
    private Vector3 m_targetScreenVec;//当前物体对应的屏幕坐标
    private bool m_bTrunX = false;//是否转弯
    private bool m_bTrunXOver = false;//是否转弯结束
    private Rigidbody m_rigidBody;//自身刚体
    private Dictionary<MeshCollider, bool> m_dicBox = new Dictionary<MeshCollider, bool>();
    private WheelCollider[] wheels;
    private DOTweenPath m_tweenPath;
    private bool m_bControlPlay = true;
    Vector3[] waypoints = new[] { new Vector3(5.887576f, 0.3f, -12.40118f), new Vector3(3.929976f, 0.3f, -28.24078f), new Vector3(-0.5266161f, 0.3f, -48.95566f), new Vector3(-91.0928f, 0.3f, -52.08097f) };
    private Vector3 m_curPoint;//当前节点
    private int m_pointIndex = 0;//节点计数
    private bool m_bControlPoint = true;
    private bool m_bControlStartMove = false;
    private Transform m_collisonTargetTrans;//碰到的其他目标
    private bool m_bIsCollisonTarget = false;//是否碰到了其他目标
    private float m_carTopHeight = 2.26f;//车子顶部高度
    private RectTransform m_thumbRT;//摇杆
    private Camera m_camera;
    private float m_cameraZOffset = 0.0f;//相机z偏移
    private Dictionary<Rigidbody, bool> m_dicRigidDic = new Dictionary<Rigidbody, bool>();
    // Start is called before the first frame update
    void Start()
    {
        //------------罗货物------------
        //m_targetTrans = m_targetParentTrans.GetComponentsInChildren<MeshCollider>();
        //for(int i = 0;i<m_targetTrans.Length;i++)
        //{
        //    m_dicBox.Add(m_targetTrans[i], false);
        //}
        //------------罗货物------------
        m_rigidBody = GetComponent<Rigidbody>();
        wheels = GetComponentsInChildren<WheelCollider>();
        //for (int i = 0; i < wheels.Length; i++)
        //{
        //    wheels[i].enabled = false;
        //}
        m_rigidBody.centerOfMass = centerOfMass.localPosition;
        //m_rigidBody.isKinematic = true;
        m_tweenPath = GetComponent<DOTweenPath>();
        m_curPoint = waypoints[0];
        //GameServices.inputService.pad.onTouchUp += OnTouchUp;
        GameServices.inputService.joyStick.onTouchStart.AddListener(OnTouchStart);
        GameServices.inputService.joyStick.onTouchUp.AddListener(OnTouchUp);
        m_thumbRT = GameServices.inputService.joyStick.thumb;
        m_camera = Camera.main;
        m_cameraZOffset = m_camera.transform.position.z;
        Rigidbody[] varBody = m_eggParent.GetComponentsInChildren<Rigidbody>();
        for (int i = 0; i < varBody.Length; i++)
        {
            m_dicRigidDic.Add(varBody[i], true);
        }
    }
    private void OnCollisionEnter(Collision other)
    {
        //-----------------罗货物--------------
        //if (other.collider.gameObject.CompareTag("Target"))
        //{
        //    MeshCollider varBox = other.collider.gameObject.GetComponent<MeshCollider>();
        //    if (m_dicBox.ContainsKey(varBox))
        //    {
        //        m_dicBox[varBox] = true;
        //    }
        //    RotateInvoke();
        //}
        //-----------------罗货物--------------
        if (other.collider.gameObject.CompareTag("Egg"))
        {
            Rigidbody varBody = other.collider.transform.parent.GetComponent<Rigidbody>();
            if(varBody && m_dicRigidDic.ContainsKey(varBody) && m_dicRigidDic[varBody])
            {
                m_dicRigidDic[varBody] = false;
                Transform varTrans = other.collider.transform.parent;
                varTrans.position = m_eggTrans.position;
            }
        }
    }
    private void OnCollisionExit(Collision other)
    {
        if (other.collider.gameObject.CompareTag("Target"))
        {
            MeshCollider varBox = other.collider.gameObject.GetComponent<MeshCollider>();
            //if (m_dicBox.ContainsKey(varBox))
            //{
            //    m_dicBox[varBox] = false;
            //}
        }
    }
    //invoke旋转
    void RotateInvoke()
    {
        CancelRotateInvoke();
        InvokeRepeating("RotateTarget", 0.5f, 0.5f);
    }
    //取消invoke
    void CancelRotateInvoke()
    {
        if(IsInvoking("RotateTarget"))
        {
            CancelInvoke("RotateTarget");
        }
    }
    //碰到其他目标
    public void SetTargetCollison(Transform trans,bool bool_)
    {
        //--------------罗货物---------------
        //m_collisonTargetTrans = trans;
        //m_bIsCollisonTarget = bool_;
        //if(m_bIsCollisonTarget)
        //{
        //    RotateInvoke();
        //}
        //--------------罗货物---------------
    }
    // Update is called once per frame
    void FixedUpdate()
    {
        if (!BattleCtrl.instance.isStartBattle)
        {
            return;
        }
        //if (BattleCtrl.instance.isEndBattle)
        //{
        //    m_rigidBody.isKinematic = true;
        //}

        //-----------------罗货物-----------------------
        //if (Input.GetMouseButtonDown(0))
        //{
        //    Clicked();
        //}
        //-----------------罗货物-----------------------
        if (Input.GetMouseButton(0))
        {
            m_bControlMouseUp = false;
            for (int i = 0; i < wheels.Length; i++)
            {
                wheels[i].brakeTorque = 0;
            }
            if (m_bIsCanMove)
            {
                m_bControlStartMove = true;
                //if (m_curSpeed < m_maxSpeed)
                //{
                //    m_curSpeed += Time.deltaTime * m_addSpeed;
                //}
                //else
                //{
                //    m_curSpeed = m_maxSpeed;
                //}
                if (m_curMotorSpeed < m_maxMotorSpeed)
                {
                    m_curMotorSpeed += Time.deltaTime * m_addMotorSpeed;
                }
                else
                {
                    m_curMotorSpeed = m_maxMotorSpeed;
                }
                //if(m_bTrunXOver)
                //{
                //    m_rigidBody.velocity = -Vector3.right * m_curSpeed;
                //}
                //else
                //{
                //    m_rigidBody.velocity = transform.forward * m_curSpeed * 3.5f;
                //}
                //transform.Translate(-Vector3.forward * m_curSpeed, Space.Self);
                for (int i = 0; i < driveWheel.Length; i++)
                {
                    driveWheel[i].motorTorque = m_curMotorSpeed;
                }
                //if (m_bControlPlay)
                //{
                //    m_bControlPlay = false;
                //    m_tweenPath.DOPlay();
                //}
                //m_tweenPath.GetTween().timeScale = m_curSpeed;
            }
            //---------------------罗货物-------------------------
            //if(m_curTargetTrans && !m_bIsCanMove)
            //{
            //    m_curTargetTrans.transform.position = Camera.main.ScreenToWorldPoint(new Vector3(Input.mousePosition.x,
            //    Input.mousePosition.y, m_targetScreenVec.z)) + m_offset;
            //}
            //if(!m_bIsCanMove && m_curTargetTrans) 
            //{
            //    //十字架位置
            //    float varX = (Input.mousePosition.x - Screen.width / 2f) / (Screen.width / GlobalConfig.NormalWidth);
            //    float varY = (Input.mousePosition.y - Screen.height / 2f) / (Screen.width / GlobalConfig.NormalWidth);
            //    BattleCtrl.instance.battleUI.SetSymbolPos(varX, varY);
            //}
            //---------------------罗货物-------------------------
        }
        if (m_bControlMouseUp)
        {
            if (m_bIsCanMove)
            {
                //if (m_curSpeed > 0)
                //{
                //    m_curSpeed -= Time.deltaTime * m_addSpeed;
                //}
                //else
                //{
                //    m_curSpeed = 0.0f;
                //}
                if (m_curMotorSpeed > 0)
                {
                    m_curMotorSpeed -= Time.deltaTime * m_addMotorSpeed;
                }
                else
                {
                    m_curMotorSpeed = 0.0f;
                }
                //if (m_bTrunXOver)
                //{
                //    m_rigidBody.velocity = -Vector3.right * m_curSpeed;
                //}
                //else
                //{
                //    m_rigidBody.velocity = transform.forward * m_curSpeed * 3.0f;
                //}
                //transform.Translate(-Vector3.forward * m_curSpeed, Space.Self);
                for (int i = 0; i < driveWheel.Length; i++)
                {
                    driveWheel[i].motorTorque = m_curMotorSpeed;
                }
                //m_tweenPath.GetTween().timeScale = m_curSpeed;
            }
        }
        //确保最低位置
        //------------------罗货物-----------------------
        //if(m_curTargetTrans)
        //{
        //    Vector3 varPos = m_curTargetTrans.transform.position;
        //    if (varPos.y < 0.5f)
        //    {
        //        varPos.y = 0.5f;
        //    }
        //    if(m_dicBox.ContainsKey(m_curTargetTrans) && m_dicBox[m_curTargetTrans])
        //    {
        //        varPos.y = m_carTopHeight;
        //    }
        //    if (m_collisonTargetTrans && m_bIsCollisonTarget)
        //    {
        //        varPos.y = m_collisonTargetTrans.localPosition.y + m_collisonTargetTrans.localScale.y;
        //    }
        //    if(varPos.y < m_carTopHeight)
        //    {
        //        CancelRotateInvoke();
        //    }
        //    m_curTargetTrans.transform.position = varPos;
        //}
        //------------------罗货物-----------------------
        //Vector3 varPosSelf = transform.localPosition;
        //varPosSelf.y = 0.5f;
        //transform.localPosition = varPosSelf;
        m_rigidBody.AddForce(-transform.up * m_curMotorSpeed);
        if(m_camera)
        {
            Vector3 varCamera = m_camera.transform.position;
            varCamera.z = transform.position.z + m_cameraZOffset;
            m_camera.transform.position = varCamera;
        }
        //UpdateTurn();
    }
    void OnTouchStart()
    {
        float varX = (Input.mousePosition.x - Screen.width / 2f) / (Screen.width / GlobalConfig.NormalWidth);
        float varY = (Input.mousePosition.y - Screen.height / 2f) / (Screen.width / GlobalConfig.NormalWidth);
        Vector2 varVec2 = GameServices.inputService.joyStick.gameObject.transform.localPosition;
        varVec2.x = varX;
        varVec2.y = varY;
        GameServices.inputService.joyStick.gameObject.transform.localPosition = varVec2;
        Vector2 varThumb = m_thumbRT.sizeDelta;
        varThumb.x = 80;
        varThumb.y = 80;
        m_thumbRT.sizeDelta = varThumb;
        BattleCtrl.instance.battleUI.ShowJoystick();
    }
    // 抬起回调
    void OnTouchUp()
    {
        if (!BattleCtrl.instance.isStartBattle)
        {
            return;
        }
        //m_bControlPlay = true;
        m_bControlMouseUp = true;
        for (int i = 0; i < wheels.Length; i++)
        {
            wheels[i].brakeTorque = 1500.0f;//m_curSpeed / m_maxSpeed;
        }
        //--------------罗货物------------------------------
        //if (m_curTargetTrans)
        //{
        //    MeshCollider varBox = m_curTargetTrans.GetComponent<MeshCollider>();
        //    if (m_dicBox.ContainsKey(varBox))
        //    {
        //        m_dicBox[varBox] = false;
        //    }
        //    m_curTargetTrans = null;
        //}
        //m_collisonTargetTrans = null;
        //m_bIsCollisonTarget = false;
        //CancelDelayMoveHandle();
        //Invoke("DelayMoveHandle", 0.5f);
        //--------------罗货物------------------------------
        BattleCtrl.instance.battleUI.SetSymbolPos(0, 0);

        //----------摇杆操作
        BattleCtrl.instance.battleUI.HideJoystick();
        Vector2 varThumb = m_thumbRT.sizeDelta;
        varThumb.x = 4000;
        varThumb.y = 4000;
        m_thumbRT.sizeDelta = varThumb;
    }
    void CancelDelayMoveHandle()
    {
        if (IsInvoking("DelayMoveHandle"))
        {
            CancelInvoke("DelayMoveHandle");
        }
    }
    //延时判断是否可以移动处理
    private void DelayMoveHandle()
    {
        int varIndex = 0;
        if (!m_bIsCanMove)
        {
            for (int i = 0; i < m_targetTrans.Length; i++)
            {
                Rigidbody varBody = m_targetTrans[i].GetComponent<Rigidbody>();
                if (varBody)
                {
                    varBody.isKinematic = true;
                }
            }
            if (m_targetTrans != null)
            {
                for (int i = 0; i < m_targetTrans.Length; i++)
                {
                    if (m_targetTrans[i].transform.position.y >= 2.2f)
                    {
                        varIndex++;
                    }
                }
            }
            if (varIndex >= 3)
            {
                m_bIsCanMove = true;
                for (int i = 0; i < wheels.Length; i++)
                {
                    wheels[i].enabled = true;
                }
                m_rigidBody.isKinematic = false;
                for (int i = 0; i < m_targetTrans.Length; i++)
                {
                    Rigidbody varBody = m_targetTrans[i].GetComponent<Rigidbody>();
                    if (varBody)
                    {
                        varBody.isKinematic = false;
                        varBody.constraints = RigidbodyConstraints.None;
                    }
                }
            }
        }
    }
    private void Update()
    {
        if (m_bIsCanMove && m_bControlStartMove && !BattleCtrl.instance.isEndBattle)
        {
            //UpdateTurnHandle();
            UpdateJoystick();
        }
    }
    //摇杆控制
    void UpdateJoystick()
    {
        for (int i = 0; i < turnWheel.Length; i++)
        {
            turnWheel[i].steerAngle = Mathf.Lerp(turnWheel[i].steerAngle, GameServices.inputService.joyStick.axisX.axisValue*30.0f, 1.0f);
        }
    }
    //车子朝向处理
    void UpdateTurnHandle()
    {
        Vector3 targetDir = (m_curPoint - transform.position).normalized;
        //if (!targetDir.Equals(Vector3.zero))
        //{
        //    Quaternion targetRotation = Quaternion.LookRotation(targetDir, Vector3.up);
        //    transform.rotation = Quaternion.Lerp(transform.rotation, targetRotation, 0.2f);
        //}
        float varDeg = Mathf.Rad2Deg * (Mathf.Acos(Vector3.Dot(transform.forward, targetDir)));
        if(varDeg >= 45.0f)
        {
            varDeg = 45.0f;
        }
        float varCross = Vector3.Cross(transform.forward, targetDir).y;
        for (int i = 0; i < turnWheel.Length; i++)
        {
            if(varCross > 0)
            {
                turnWheel[i].steerAngle = Mathf.Lerp(turnWheel[i].steerAngle, varDeg, 1.0f);
            }
            else if(varCross == 0)
            {
                turnWheel[i].steerAngle = Mathf.Lerp(turnWheel[i].steerAngle, 0, 1.0f);
            }
            else
            {
                turnWheel[i].steerAngle = Mathf.Lerp(turnWheel[i].steerAngle, -varDeg, 1.0f);
            }
        }
        if(Vector3.SqrMagnitude(transform.position - m_curPoint) <= 1.0f)
        {
            if(m_bControlPoint)
            {
                m_bControlPoint = false;
                m_pointIndex++;
                m_curPoint = waypoints[m_pointIndex];
            }
        }
        else
        {
            m_bControlPoint = true;
        }
    }
    //返回剩余物体个数
    public int GetLeftBoxNum()
    {
        int varIndex = 0;
        if (m_targetTrans != null)
        {
            for (int i = 0; i < m_targetTrans.Length; i++)
            {
                if (m_targetTrans[i].transform.position.y >= 2.0f)
                {
                    varIndex++;
                }
            }
        }
        return varIndex;
    }
    void Clicked()
    {
        if(m_bIsCanMove)
        {
            return;
        }
        Ray ray = Camera.main.ScreenPointToRay(Input.mousePosition);

        RaycastHit hit = new RaycastHit();

        if (Physics.Raycast(ray, out hit))
        {
            if (hit.collider && hit.collider.gameObject.CompareTag("Target"))
            {
                for(int i = 0;i<m_targetTrans.Length;i++)
                {
                    if(string.Equals(hit.collider.name,m_targetTrans[i].name))
                    {
                        m_curTargetTrans = m_targetTrans[i];
                        //重置状态
                        CancelDelayMoveHandle();
                        CancelRotateInvoke();
                        m_curTargetTrans.GetComponent<Rigidbody>().isKinematic = false;
                        break;
                    }
                }
                m_targetScreenVec = Camera.main.WorldToScreenPoint(m_curTargetTrans.transform.position);
                //偏移值=物体的世界坐标，减去转化之后的鼠标世界坐标（z轴的值为物体屏幕坐标的z值）
                m_offset = m_curTargetTrans.transform.position - Camera.main.ScreenToWorldPoint(new Vector3
                (Input.mousePosition.x, Input.mousePosition.y, m_targetScreenVec.z));
            }
        }
    }
    void RotateTarget()
    {
        if (m_bIsCanMove)
        {
            return;
        }
        if(m_curTargetTrans)
        {
            m_curTargetTrans.transform.Rotate(transform.up, 90.0f);
        }
    }
    //开始拐弯
    public void SetTurn()
    {
        m_bTrunX = true;
    }
    //拐弯回正
    public void SetTurnEnd()
    {
        m_bTrunX = false;
        m_bTrunXOver = true;
        GameServices.timerServices.Push(this, 0.5f, delegate
        {
            m_bTrunXOver = false;
        });
    }
    void UpdateTurn()
    {
        if (m_bTrunX)
        {
            //m_rigidBody.angularVelocity = Vector3.up*m_curSpeed/2;
            //Vector3 varVec3 = m_rigidBody.velocity;
            //varVec3.x = -Vector3.right.x*m_curSpeed/2;
            //varVec3.z = -Vector3.forward.z*m_curSpeed;
            //m_rigidBody.velocity = varVec3;
            //if (transform.localEulerAngles.y >= 90.0f && transform.localEulerAngles.y <= 180.0f)
            //{
            //    m_bTrunX = false;
            //    m_bTrunXOver = true;
            //    m_rigidBody.angularVelocity = Vector3.zero;
            //    transform.localEulerAngles = Vector3.up * 90.0f;
            //    m_rigidBody.velocity = Vector3.zero;
            //}
            for (int i = 0; i < turnWheel.Length; i++)
            {
                turnWheel[i].steerAngle = Mathf.Lerp(turnWheel[i].steerAngle, 30.0f + m_curSpeed/m_maxSpeed*30, 0.5f+ m_curSpeed / m_maxSpeed*0.5f);
            }
            //if (transform.localEulerAngles.y >= 268.0f)
            //{
            //    m_bTrunX = false;
            //    m_bTrunXOver = true;
            //    m_rigidBody.angularVelocity = Vector3.zero;
            //    m_rigidBody.velocity = Vector3.zero;
            //}
        }
        if(m_bTrunXOver)
        {
            for (int i = 0; i < turnWheel.Length; i++)
            {
                turnWheel[i].steerAngle = Mathf.Lerp(turnWheel[i].steerAngle, 0, 0.5f);
            }
        }
    }
    private void OnDestroy()
    {
        m_targetTrans = null;
        m_curTargetTrans = null;
        //if (GameServices.inputService != null)
        //{
        //    GameServices.inputService.pad.onTouchUp -= OnTouchUp;
        //}
        CancelDelayMoveHandle();
        CancelRotateInvoke();
    }
}
