﻿//using Common;
using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class GameServices : MonoBehaviour
{
    /// <summary>
    /// 输入服务
    /// </summary>
    public static InputServices inputService;

    /// <summary>
    /// 调试设置服务
    /// </summary>
    //public static DebugServices debugService = new DebugServices();

    private static ConfigServices _ConfigService = new ConfigServices();

    /// <summary>
    /// 战斗配置服务
    /// </summary>
    public static BattleConfig configService => _ConfigService.config;

    /// <summary>
    /// 计时器服务
    /// </summary>
    public static TimerServices timerServices = new TimerServices();

    public static AudioServices audioServices;

    //public static PoolObjServices poolObjServices;

    public static GameServices Create()
    {
        var services = GameObject.FindObjectOfType<GameServices>();
        if (services == null)
        {
            var go = new GameObject("GameServices");
            GameObject.DontDestroyOnLoad(go);
            return go.AddComponent<GameServices>();
        }

        return services;
    }

    private void Start()
    {
    }

    public void Init()
    {
        Find();

        if (inputService == null)
            inputService = transform.GetComponent<InputServices>();
        inputService?.OnStart();

        if (_ConfigService == null)
            _ConfigService = new ConfigServices();
        _ConfigService?.OnStart();

        audioServices = GameObject.FindObjectOfType<AudioServices>();
        if (audioServices == null)
        {
            audioServices = AudioServices.Create(transform);
        }

        //poolObjServices = GameObject.FindObjectOfType<PoolObjServices>();
    }

    void Find()
    {
        inputService = transform.GetComponent<InputServices>();
    }

    void Update()
    {
        if (inputService != null)
        {
            inputService.OnUpdate();
        }

        if (timerServices != null)
        {
            timerServices.Update(Time.deltaTime);
        }
    }

    /// <summary>
    /// 
    /// </summary>
    public void ClearPoolData()
    {
        //poolObjServices.OnDispose();
    }

    public void OnDisponse()
    {
        inputService?.OnDispose();
        inputService = null;

        _ConfigService?.OnDispose();
        _ConfigService = null;

        timerServices?.OnDispose();
    }
}
