﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public interface IBaseServices
{
    /// <summary>
    /// 是否启用该服务
    /// </summary>
    bool servicesEnable { get; set; }

    void OnStart();

    void OnUpdate();

    /// <summary>
    /// 释放
    /// </summary>
    void OnDispose();
}

public abstract class BaseServices : MonoBehaviour, IBaseServices
{
    /// <summary>
    /// 默认启用服务
    /// </summary>
    bool _ServicesEnable = true;
    public bool servicesEnable { get => _ServicesEnable; set => _ServicesEnable = value; }

    public virtual void OnDispose()
    {
    }

    public virtual void OnStart()
    {
    }

    public virtual void OnUpdate()
    {
    }

    /// <summary>
    /// 启用服务
    /// </summary>
    public virtual void EnableService()
    {

    }

    /// <summary>
    /// 禁用服务
    /// </summary>
    public virtual void DisableService()
    {

    }
}
