﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class FollowTarget : MonoBehaviour
{
    //游戏人物 的位置
    public Transform player;

    //游戏人物与 相机的差
    private Vector3 offset;
    private bool m_bTrun = false;//是否转弯
    // Use this for initialization
    void Start()
    {
        offset = transform.position - player.position;
    }


    // Update is called once per frame
    void LateUpdate()
    {
        //player.TransformDirection(offset)
        //世界坐标转换为局部坐标
        Vector3 targetPosition = player.position + player.TransformDirection(offset);
        //Vector3.Lerp 计算相机位置 和 目标位置的插值
        transform.position = Vector3.Lerp(transform.position, targetPosition, 1);
        //相机的目标看向 游戏人物
        transform.LookAt(player.position);
        UpdateTurn();
    }
    //开始拐弯
    public void SetTurn()
    {
        m_bTrun = true;
    }
    void UpdateTurn()
    {
        if (m_bTrun)
        {
            transform.localRotation = Quaternion.Lerp(transform.localRotation, Quaternion.Euler(transform.localEulerAngles.x, -90, transform.localEulerAngles.z), 0.2f);
        }
    }

}
