﻿using UnityEngine;
using System;
using System.Collections;
using System.Collections.Generic;

class Pool
{
    private Stack<GameObject> m_objStack = new Stack<GameObject>();
    private List<GameObject> m_objList = new List<GameObject>();

    //the root obj for unused obj
    private GameObject m_rootObj;
    private float lastUsedTime = -1;
    //private PoolInflationType inflationType;
    private string poolName;
    private string prefabPath;
    private GameObject m_instanceObj;
    //private int objectsInUse = 0;
    //public int GetObjectsInUse { get { return objectsInUse; } }

    public Pool(GameObject go)
    {
        lastUsedTime = Time.time;
        m_instanceObj = go;
        this.poolName = go.name;
        //this.inflationType = type;
        m_rootObj = new GameObject(poolName + "Pool");
        m_rootObj.transform.SetParent(PoolManager.Instance.transform);
    }

    public GameObject GetPoolObject()
    {
        GameObject varGo = null;
        if (m_objStack.Count > 0)
        {
            varGo = m_objStack.Pop();
        }
        else
        {
            varGo = GameObject.Instantiate(m_instanceObj);
            varGo.name = varGo.name.Replace("(Clone)", "");
            m_objList.Add(varGo);
        }
        varGo.SetActive(true);
        varGo.transform.SetParent(m_rootObj.transform);
        return varGo;
    }

    //o(1)
    public void ReturnObjectToPool(GameObject go)
    {
        if (go)
        {
            m_objStack.Push(go);
            go.SetActive(false);
        }
    }
    public void DestroyObj()
    {
        GameObject.Destroy(m_rootObj);
        m_rootObj = null;
        m_objList.Clear();
        m_objList = null;
        m_objStack = null;
    }
}