﻿using UnityEngine;

public class SurfacePoint : MonoBehaviour
{
    [SerializeField]
    private RayFire.RayfireBomb rayfireBomb;

    private void Update()
    {
        if (Input.GetMouseButtonDown(0))
        {
            Clicked();
        }
    }

    void Clicked()
    {
        Ray ray = Camera.main.ScreenPointToRay(Input.mousePosition);

        RaycastHit hit = new RaycastHit();

        if (Physics.Raycast(ray, out hit))
        {
            if(hit.collider.tag == "Target" && GameManager.Instance.canBePlace)
            {
                Debug.Log(hit.point);
                GameObject go = Instantiate(rayfireBomb.gameObject) as GameObject;
                go.transform.position = hit.point;
                GameManager.Instance.SetBomb(go.GetComponent<RayFire.RayfireBomb>());
            }
        }
    }
}
