﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class StorageView : MonoBehaviour
{
    public Transform m_targetParentTrans;//障碍物父节点
    private MeshCollider[] m_targetTrans;//所有目标
    private MeshCollider m_curTargetTrans;//当前抓的目标
    private Vector3 m_offset;//偏移值
    private Vector3 m_targetScreenVec;//当前物体对应的屏幕坐标
    private Transform m_collisonTargetTrans;//碰到的其他目标
    private bool m_bIsCollisonTarget = false;//是否碰到了其他目标
    private Dictionary<MeshCollider, bool> m_dicBox = new Dictionary<MeshCollider, bool>();
    private Vector3 m_cameraTargetPos = new Vector3(1, 5.6f, -4.5f);//镜头目标位置
    private Quaternion m_cameraTargetRotate = Quaternion.Euler(60, 0, 0);//镜头目标旋转
    private float m_topHeight = 1.25f;//顶部高度
    private float m_bottomHeight = 0.25f;//底部高度
    private Camera m_camera;
    private bool m_bIsHitTarget = false;
    // Start is called before the first frame update
    void Start()
    {
        m_targetTrans = m_targetParentTrans.GetComponentsInChildren<MeshCollider>();
        for (int i = 0; i < m_targetTrans.Length; i++)
        {
            m_dicBox.Add(m_targetTrans[i], false);
        }
        m_camera = Camera.main;
        GameServices.inputService.pad.onTouchUp += OnTouchUp;
    }
    private void OnCollisionEnter(Collision other)
    {
        if (other.collider.gameObject.CompareTag("Target"))
        {
            MeshCollider varBox = other.collider.gameObject.GetComponent<MeshCollider>();
            if (m_dicBox.ContainsKey(varBox))
            {
                m_dicBox[varBox] = true;
            }
        }
    }
    private void OnCollisionExit(Collision other)
    {
        if (other.collider.gameObject.CompareTag("Target"))
        {
            MeshCollider varBox = other.collider.gameObject.GetComponent<MeshCollider>();
            if (m_dicBox.ContainsKey(varBox))
            {
                m_dicBox[varBox] = false;
            }
        }
    }
    // Update is called once per frame
    void Update()
    {
        if (!BattleCtrl.instance.isStartBattle)
        {
            return;
        }
        if (Input.GetMouseButtonDown(0))
        {
            Clicked();
        }
        if (Input.GetMouseButton(0))
        {
            if (m_curTargetTrans)
            {
                m_targetScreenVec = Camera.main.WorldToScreenPoint(m_curTargetTrans.transform.position);
                m_curTargetTrans.transform.position = Camera.main.ScreenToWorldPoint(new Vector3(Input.mousePosition.x,
                Input.mousePosition.y, m_targetScreenVec.z)) + m_offset;
                //十字架位置
                float varX = (Input.mousePosition.x - Screen.width / 2f) / (Screen.width / GlobalConfig.NormalWidth);
                float varY = (Input.mousePosition.y - Screen.height / 2f) / (Screen.width / GlobalConfig.NormalWidth);
                BattleCtrl.instance.battleUI.SetSymbolPos(varX, varY);
            }
        }
        //确保最低位置
        if (m_curTargetTrans)
        {
            Vector3 varPos = m_curTargetTrans.transform.position;
            if (varPos.y < m_bottomHeight)
            {
                varPos.y = m_bottomHeight;
            }
            if (m_dicBox.ContainsKey(m_curTargetTrans) && m_dicBox[m_curTargetTrans])
            {
                varPos.y = m_topHeight;
            }
            else
            {
                //varPos.y = m_bottomHeight;
            }
            if (m_collisonTargetTrans && m_bIsCollisonTarget)
            {
                varPos.y = m_collisonTargetTrans.localPosition.y + m_collisonTargetTrans.localScale.y;
            }
            m_curTargetTrans.transform.position = varPos;
        }
        if(m_bIsHitTarget)
        {
            m_camera.transform.position = Vector3.Lerp(m_camera.transform.position, m_cameraTargetPos, 0.2f);
            m_camera.transform.rotation = Quaternion.Lerp(m_camera.transform.rotation, m_cameraTargetRotate, 0.2f);
        }
    }
    // 抬起回调
    void OnTouchUp()
    {
        if (m_curTargetTrans)
        {
            MeshCollider varBox = m_curTargetTrans.GetComponent<MeshCollider>();
            if (m_dicBox.ContainsKey(varBox))
            {
                m_dicBox[varBox] = false;
            }
            m_curTargetTrans = null;
        }
        m_collisonTargetTrans = null;
        m_bIsCollisonTarget = false;
        BattleCtrl.instance.battleUI.SetSymbolPos(0, 0);
    }
    //碰到其他目标
    public void SetTargetCollison(Transform trans, bool bool_)
    {
        m_collisonTargetTrans = trans;
        m_bIsCollisonTarget = bool_;
    }
    void Clicked()
    {
        Ray ray = Camera.main.ScreenPointToRay(Input.mousePosition);

        RaycastHit hit = new RaycastHit();

        if (Physics.Raycast(ray, out hit))
        {
            if (hit.collider && hit.collider.gameObject.CompareTag("Target"))
            {
                m_bIsHitTarget = true;
                for (int i = 0; i < m_targetTrans.Length; i++)
                {
                    if (string.Equals(hit.collider.name, m_targetTrans[i].name))
                    {
                        m_curTargetTrans = m_targetTrans[i];
                        break;
                    }
                }
                m_targetScreenVec = Camera.main.WorldToScreenPoint(m_curTargetTrans.transform.position);
                //偏移值=物体的世界坐标，减去转化之后的鼠标世界坐标（z轴的值为物体屏幕坐标的z值）
                m_offset = m_curTargetTrans.transform.position - Camera.main.ScreenToWorldPoint(new Vector3
                (Input.mousePosition.x, Input.mousePosition.y, m_targetScreenVec.z));
            }
        }
    }
    private void OnDestroy()
    {
        m_targetTrans = null;
        m_curTargetTrans = null;
        if (GameServices.inputService != null)
        {
            GameServices.inputService.pad.onTouchUp -= OnTouchUp;
        }
    }
}
