﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class TargetCollision : MonoBehaviour
{
    private bool m_bControl = true;
    private void OnCollisionEnter(Collision other)
    {
        if (other.collider.gameObject.CompareTag("Target") && m_bControl)
        {
            m_bControl = false;
            BattleCtrl.instance.levelManager.curLevel.storageView.SetTargetCollison(transform, true);
        }
    }
    private void OnCollisionExit(Collision other)
    {
        if (other.collider.gameObject.CompareTag("Target") && !m_bControl)
        {
            m_bControl = true;
            MeshCollider varBox = other.collider.gameObject.GetComponent<MeshCollider>();
            BattleCtrl.instance.levelManager.curLevel.storageView.SetTargetCollison(transform, false);
        }
    }
}
