
using UnityEngine;
using UnityEditor;

[CanEditMultipleObjects, CustomEditor(typeof(MegaAttach))]
public class MegaAttachEditor : Editor
{
	public override void OnInspectorGUI()
	{
		MegaAttach mod = (MegaAttach)target;

#if !UNITY_5 && !UNITY_2017 && !UNITY_2018 && !UNITY_2019 && !UNITY_2020
		EditorGUIUtility.LookLikeControls();
#endif
		//DrawDefaultInspector();

		mod.target = (MegaModifiers)EditorGUILayout.ObjectField("Target", mod.target, typeof(MegaModifiers), true);

		mod.attachforward = EditorGUILayout.Vector3Field("Attach Fwd", mod.attachforward);
		mod.AxisRot = EditorGUILayout.Vector3Field("Axis Rot", mod.AxisRot);
		mod.radius = EditorGUILayout.FloatField("Radius", mod.radius);
		mod.up = EditorGUILayout.Vector3Field("Up", mod.up);
		mod.worldSpace = EditorGUILayout.Toggle("World Space", mod.worldSpace);

		if ( GUI.changed )
		{
			EditorUtility.SetDirty(mod);
		}

		if ( !mod.attached )
		{
			if ( GUILayout.Button("Attach") )
			{
				mod.AttachIt();
				EditorUtility.SetDirty(mod);
			}
		}
		else
		{
			if ( GUILayout.Button("Detach") )
			{
				mod.DetachIt();
				EditorUtility.SetDirty(mod);
			}
		}
	}
}