﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class UpdateProjectorRT : MonoBehaviour
{
    RenderTexture renderTexture;
    public Texture TestTexture;
    public bool testTextureOffOn;
    public int Resolution;
    public Material mat;
    public Camera cam;
    public bool RenderOffOn;

    int SkillIndicatorMainTexID;

    private void Start()
    {
        SkillIndicatorMainTexID = Shader.PropertyToID("_SkillIndicatorMainTex");
        RenderOffOn = true;
        testTextureOffOn = false;
        Resolution = 512;
    }

    private void OnPreRender()
    {
        if (!RenderOffOn) return;
        if (testTextureOffOn)
        {
            Matrix4x4 projMatrix = cam.projectionMatrix * cam.worldToCameraMatrix;
            Shader.SetGlobalMatrix("_ProjectionMatrix", projMatrix);
            Shader.SetGlobalTexture(SkillIndicatorMainTexID, TestTexture);
        }
        else
        {
            Graphics.Blit(null, renderTexture, mat);
            Matrix4x4 projMatrix = cam.projectionMatrix * cam.worldToCameraMatrix;
            Shader.SetGlobalMatrix("_ProjectionMatrix", projMatrix);
            Shader.SetGlobalTexture(SkillIndicatorMainTexID, renderTexture);
        }
    }

    public void CreateRT()
    {
        renderTexture = new RenderTexture(Resolution, Resolution, 0);
        renderTexture.wrapMode = TextureWrapMode.Clamp;

        Shader.SetGlobalFloat("_SkillIndicatorOffOn", 1);
    }

    public void ReleaseRT()
    {
        DestroyImmediate(renderTexture);
    }
}
