﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class SecondLevelTrigger : MonoBehaviour
{
    private bool m_bControl = true;
    private List<MeshRenderer> m_lst = new List<MeshRenderer>();
    private void OnTriggerEnter(Collider other)
    {
        if (other.gameObject.CompareTag("Target"))
        {
            StorageView varView = BattleCtrl.instance.levelManager.curLevel.storageView;
            if(varView)
            {
                MeshRenderer varMesh = other.GetComponent<MeshRenderer>();
                if (varMesh && !m_lst.Contains(varMesh))
                {
                    varView.EnterTopBox(other.name);
                    m_lst.Add(varMesh);
                }
            }
        }
    }
    private void OnTriggerExit(Collider other)
    {
        if (other.gameObject.CompareTag("Target"))
        {
            StorageView varView = BattleCtrl.instance.levelManager.curLevel.storageView;
            if (varView)
            {
                MeshRenderer varMesh = other.GetComponent<MeshRenderer>();
                if (varMesh && m_lst.Contains(varMesh))
                {
                    varView.ExitTopBox(other.name);
                    m_lst.Remove(varMesh);
                }
            }
        }
    }
    //设置退出
    public void SetExit(MeshRenderer other)
    {
        StorageView varView = BattleCtrl.instance.levelManager.curLevel.storageView;
        if (varView)
        {
            if (m_lst.Contains(other))
            {
                varView.ExitTopBox(other.name);
                m_lst.Remove(other);
            }
        }
    }
}
