﻿//关卡控制器,处理关卡具体逻辑,持有关卡内的数据层和表现层
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Profiling;

/// <summary>
/// 关卡控制器,通过BattleCtrl获取到LevelCtrl
/// </summary>
public class LevelCtrl : MonoBehaviour
{

    public ChainView m_chainView;//爪钩view
    public ChainRopeView m_chainRopeView;//娃娃机爪钩
    public Camera m_camera;
    public CarView m_carView;//车
    //public TargetView m_targetView;//触发器
    public ChainView chainView => m_chainView;
    public ChainRopeView chainRopeView => m_chainRopeView;
    public Camera cam => m_camera;
    public CarView carView => m_carView;
    //public TargetView targetView => m_targetView;
    BattleCtrl _BattleCtrl;

    [Header("当前是第几关，从0开始。例如第一关则填0")]
    public int curLevelIndex;


    /// <summary>
    /// 当前显示的是否是该关卡
    /// </summary>
    bool _EnableLevel;

    private float m_bestTime = 0.0f;
    public float bestTime => m_bestTime;



    private void Awake()
    {
    }

    private void Start()
    {
        Init();
    }

    void Init()
    {
    }

    /// <summary>
    /// 加载关卡时的回调
    /// </summary>
    public void OnLoadLevel()
    {
        InitBattle();
        _EnableLevel = true;
    }

    /// <summary>
    /// 卸载关卡时的回调
    /// </summary>
    public void OnUnLoadLevel()
    {
        _EnableLevel = false;
    }

    /// <summary>
    /// 初始化战斗的表现层和数据层
    /// </summary>
    private void InitBattle()
    {
        _BattleCtrl = BattleCtrl.instance;
    }
    void Update()
    {
        if (!_EnableLevel)
            return;

        if (!_BattleCtrl.inited || _BattleCtrl.isEndBattle || !_BattleCtrl.isStartBattle)
            return;
        m_bestTime += Time.deltaTime;
    }
}