﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class InputServices : BaseServices
{
    public BattleJoinPad pad;
    //public ETCJoystick joyStick;

    public override void OnUpdate()
    {
        base.OnUpdate();
        if(base.servicesEnable != pad.optValid)
        {
            pad.SetOptValid(base.servicesEnable);
        }
    }

    /// <summary>
    /// 控制触摸板的显示
    /// </summary>
    /// <param name="show"></param>
    public void ShowTouchPad(bool show)
    {
        pad.gameObject.SetActive(show);
    }

    public override void EnableService()
    {
        base.EnableService();
        pad.SetOptValid(true);
        ShowTouchPad(true);
        pad.ResetPointId();
        servicesEnable = true;
    }

    public override void DisableService()
    {
        base.DisableService();
        pad.SetOptValid(false);
        servicesEnable = false;
        pad.ResetPointId();
        ShowTouchPad(false);
    }
}
