﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
//using DG.Tweening;

public class FirstLevelTrigger : MonoBehaviour
{
    private bool m_bControl = true;
    private List<Collider> m_lst = new List<Collider>();
    private void OnTriggerEnter(Collider other)
    {
        if (other.gameObject.CompareTag("Target"))
        {
            StorageView varView = BattleCtrl.instance.levelManager.curLevel.storageView;
            if(!m_lst.Contains(other))
            {
                varView.InsideBox(other);
                m_lst.Add(other);
            }
        }
    }
    private void OnTriggerExit(Collider other)
    {
        if (other.gameObject.CompareTag("Target"))
        {
            StorageView varView = BattleCtrl.instance.levelManager.curLevel.storageView;
            if (m_lst.Contains(other))
            {
                varView.ExitBox();
                m_lst.Remove(other);
            }
        }
    }
}
