﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class LevelBtnItem : MonoBehaviour
{
    public Text m_gameBestTime;
    public int m_level;
    private void OnEnable()
    {
        string varKey = m_level.ToString();
        if (LocalRecord.HasKey(varKey))
        {
            int varBestTime = LocalRecord.GetIntRecord(varKey);
            m_gameBestTime.text = string.Format("{0:d2}:{1:d2}", varBestTime / 60, varBestTime % 60);
        }
        else
        {
            m_gameBestTime.text = string.Format("{0:d2}:{1:d2}", 99, 99);
        }
    }
    public void OnClickLevel(int level)
    {
        BattleCtrl.instance.levelManager.LoadSelectLevel(level);
    }
}
