﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
//using Obi;

public class FifthLevelTrigger : MonoBehaviour
{
    //public Transform m_topTrans;
    //private Rigidbody[] m_rigidBody;
    //private bool m_bControl = true;
    public Transform m_mousePosTrans;
    public float m_speed = 1.0f;
    private bool m_bEnterGround = true;
    private bool m_bEnterSuccessTarget = false;
    private Rigidbody m_mouseRigidBody;
    private Vector3 m_DefaultPos = new Vector3(2.18f,1.61f,-1.13f);
    private Vector3 m_dirPos = new Vector3(1.19f, 0, -2.11f);

    private void Start()
    {
        m_mouseRigidBody = m_mousePosTrans.gameObject.GetComponent<Rigidbody>();
        BattleCtrl.instance.levelManager.curLevel.chainRopeView.onBalloonEnterTarget += onBalloonEnterTarget;
        BattleCtrl.instance.levelManager.curLevel.chainRopeView.onBalloonEnterGround += onBalloonEnterGround;
        BattleCtrl.instance.levelManager.curLevel.chainRopeView.onBalloonEnterSuccessTarget += onBalloonEnterSuccessTarget;
        //m_rigidBody = gameObject.GetComponentsInChildren<Rigidbody>();
    }
    void onBalloonEnterTarget()
    {
        m_bEnterGround = false;
    }
    void onBalloonEnterGround()
    {
        m_bEnterGround = true;
    }
    void onBalloonEnterSuccessTarget()
    {
        m_bEnterSuccessTarget = true;
    }
    // Update is called once per frame
    void Update()
    {
        //if(m_bControl)
        //{
        //    if(m_topTrans.position.y < 6)
        //    {
        //        m_bControl = false;
        //        BattleCtrl.instance.OnBattleWin();
        //    }
        //}
        if(m_bEnterGround)
        {
            transform.Translate(Vector3.up * Time.deltaTime * m_speed, Space.World);
        }
        if(m_bEnterSuccessTarget)
        {
            m_bEnterSuccessTarget = false;
            m_mouseRigidBody.isKinematic = true;
            m_mousePosTrans.localPosition = m_DefaultPos;
        }
        else
        {
            if(m_mouseRigidBody.isKinematic)
            {
                //transform.Translate(Vector3.up * Time.deltaTime * m_speed, Space.World);
                transform.localPosition = Vector3.Lerp(transform.localPosition, m_dirPos, 0.03f);
                transform.rotation = Quaternion.Slerp(transform.rotation, Quaternion.identity, 0.03f);
            }
        }
    }
}
