﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class SecondLevelTrigger : MonoBehaviour
{
    private bool m_bControl = true;
    private List<Collider> m_lst = new List<Collider>();
    private void OnTriggerEnter(Collider other)
    {
        if (other.gameObject.CompareTag("Target"))
        {
            StorageView varView = BattleCtrl.instance.levelManager.curLevel.storageView;
            if(varView)
            {
                if (!m_lst.Contains(other))
                {
                    varView.EnterTopBox(other.name);
                    m_lst.Add(other);
                }
            }
        }
    }
    private void OnTriggerExit(Collider other)
    {
        if (other.gameObject.CompareTag("Target"))
        {
            StorageView varView = BattleCtrl.instance.levelManager.curLevel.storageView;
            if (varView)
            {
                if (m_lst.Contains(other))
                {
                    varView.ExitTopBox(other.name);
                    m_lst.Remove(other);
                }
            }
        }
    }
}
