﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class SevenLevelTwoTrigger : MonoBehaviour
{
    private bool m_bTriggerOne = false;
    private bool m_bTriggerTwo = false;
    private bool m_bControl = true;
    public bool Control => m_bControl;
    private void OnTriggerEnter(Collider other)
    {
        if (other.gameObject.CompareTag("Target") && !m_bTriggerTwo)
        {
            m_bTriggerTwo = true;
            if (m_bTriggerTwo && m_bTriggerOne)
            {
                if (m_bControl)
                {
                    m_bControl = false;
                    BattleCtrl.instance.OnBattleWin();
                    BattleCtrl.instance.levelManager.curLevel.chainRopeView.CatchObjEnterTarget();
                }
            }
            GameServices.timerServices.Push(this, 1.0f, delegate
            {
                if (m_bControl)
                {
                    m_bTriggerTwo = false;
                }
            });
        }
    }
    public void OnTriggerOne()
    {
        m_bTriggerOne = true;
        if (m_bTriggerTwo && m_bTriggerOne)
        {
            if (m_bControl)
            {
                m_bControl = false;
                BattleCtrl.instance.OnBattleWin();
                BattleCtrl.instance.levelManager.curLevel.chainRopeView.CatchObjEnterTarget();
            }
        }
        GameServices.timerServices.Push(this, 1.0f, delegate
        {
            if(m_bControl)
            {
                m_bTriggerOne = false;
            }
        });
    }
}
