﻿using System.Collections;
using System.Collections.Generic;

public class GlobalConfig 
{
    /// <summary>
    /// 是否开启手机震动
    /// </summary>
    public static bool isEnableShake = true;

    /// <summary>
    /// 是否开启音效
    /// </summary>
    public static bool isEnableSound = true;

    /// <summary>
    /// 是否开启bgm
    /// </summary>
    public static bool isEnableBgm = true;

    /// <summary>
    /// 语言类型
    /// </summary>
    public static LangeType langType;
    public static string VibrationKey = "VibrationKey";//震动Key
    public static string SoundKey = "SoundKey";//音效Key
    public static string BgmKey = "BgmKey";//音乐Key

    public static float NormalWidth = 1080f;
    public static float NormalHeight = 1920f;
    public static float CurRatio = (float)UnityEngine.Screen.height / (float)UnityEngine.Screen.width;
    public static float NormalRatio = NormalHeight / NormalWidth;
    public static float Ratio = CurRatio / NormalRatio;


    public static float CanvaUIScaleX = BattleCtrl.instance.battleUI.gameObject.transform.localScale.x;//uicanva适配大小


    //通过当前关卡返回总的数量
    public static int TotalNum()
    {
        int varLevel = BattleCtrl.instance.levelManager.CurLevelIndex;
        int num = 0;
        if(varLevel == LevelEnum.levelOneIndex)
        {
            num = 3;
        }
        else if(varLevel == LevelEnum.levelTwoIndex || varLevel == LevelEnum.levelThreeIndex
            || varLevel == LevelEnum.levelFourIndex || varLevel == LevelEnum.levelFiveIndex)
        {
            num = 4;
        }
        else if (varLevel == LevelEnum.levelSixIndex || varLevel == LevelEnum.levelSevenIndex
            || varLevel == LevelEnum.levelEightIndex || varLevel == LevelEnum.levelNineIndex)
        {
            num = 6;
        }
        return num;
    }
    //通过当前关卡返回盒子高度
    public static float BoxHeight()
    {
        int varLevel = BattleCtrl.instance.levelManager.CurLevelIndex;
        float varHeight = 0;
        if (varLevel == LevelEnum.levelOneIndex
            || varLevel == LevelEnum.levelFourIndex || varLevel == LevelEnum.levelFiveIndex
            || varLevel == LevelEnum.levelSixIndex || varLevel == LevelEnum.levelSevenIndex)
        {
            varHeight = 1.1f;
        }
        else if (varLevel == LevelEnum.levelTwoIndex || varLevel == LevelEnum.levelThreeIndex)
        {
            varHeight = 1.8f;
        }
        else if (varLevel == LevelEnum.levelEightIndex || varLevel == LevelEnum.levelNineIndex)
        {
            varHeight = 4.0f;
        }
        return varHeight;
    }
    //通过当前关卡返回胜利动画名称
    public static string WinAnimatorName()
    {
        int varLevel = BattleCtrl.instance.levelManager.CurLevelIndex;
        string varName = "成功动画";
        if (varLevel == LevelEnum.levelOneIndex)
            //|| varLevel == LevelEnum.levelFourIndex || varLevel == LevelEnum.levelFiveIndex
            //|| varLevel == LevelEnum.levelSixIndex || varLevel == LevelEnum.levelSevenIndex)
        {
            varName = "成功_N1";
        }
        else if (varLevel == LevelEnum.levelTwoIndex || varLevel == LevelEnum.levelThreeIndex)
        {
            varName = "成功_L1&2";
        }
        return varName;
    }
    //通过当前关卡返回失败动画名称
    public static string FailAnimatorName()
    {
        int varLevel = BattleCtrl.instance.levelManager.CurLevelIndex;
        string varName = "失败";
        if (varLevel == LevelEnum.levelOneIndex)
        //|| varLevel == LevelEnum.levelFourIndex || varLevel == LevelEnum.levelFiveIndex
        //|| varLevel == LevelEnum.levelSixIndex || varLevel == LevelEnum.levelSevenIndex)
        {
            varName = "失败_N1";
        }
        else if (varLevel == LevelEnum.levelTwoIndex || varLevel == LevelEnum.levelThreeIndex)
        {
            varName = "失败_L1&2";
        }
        return varName;
    }
}

public enum LangeType
{
    Chinese,
    English
}
