﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class StorageView : MonoBehaviour
{
    public Transform m_targetParentTrans;//障碍物父节点
    private MeshCollider[] m_targetTrans;//所有目标
    public BoxCollider m_triggerBox;
    public BoxCollider m_triggerTopBox;
    public Material m_redMat;//红色材质球
    public GameObject m_planeObj;//地板
    public Transform m_fixedTrans;//内置物体
    public float m_rotateSpeed = 1.0f;
    public Transform m_parent;//父节点
    public Animator m_animator;
    private MeshCollider m_curTargetTrans;//当前抓的目标
    public MeshCollider curTargetTrans => m_curTargetTrans;
    private Vector3 m_offset;//偏移值
    private Vector3 m_targetScreenVec;//当前物体对应的屏幕坐标
    private Transform m_collisonTargetTrans;//碰到的其他目标
    private bool m_bIsCollisonTarget = false;//是否碰到了其他目标
    private Dictionary<MeshCollider, bool> m_dicBox = new Dictionary<MeshCollider, bool>();
    private Dictionary<MeshCollider, bool> m_dicInsideBox = new Dictionary<MeshCollider, bool>();//放入箱子里面的box
    private Dictionary<MeshCollider, bool> m_dicInsideCollisonBox = new Dictionary<MeshCollider, bool>();//放入箱子里面的box
    private Dictionary<MeshCollider, float> m_dicPos = new Dictionary<MeshCollider, float>();//位置信息
    private Dictionary<MeshCollider, Material[]> m_dicMat = new Dictionary<MeshCollider, Material[]>();//材质信息
    private Dictionary<MeshCollider, Quaternion> m_dicRotate = new Dictionary<MeshCollider, Quaternion>();//旋转信息
    private Vector3 m_cameraTargetPos = new Vector3(0, 8.7f, -7.68f);//镜头目标位置
    private Quaternion m_cameraTargetRotate = Quaternion.Euler(50, 0, 0);//镜头目标旋转
    private float m_topHeight = 1.368f;//顶部高度
    private float m_bottomHeight = 0.25f;//底部高度
    private Camera m_camera;
    private bool m_bIsHitTarget = false;
    private float m_curTargetPosY = 0.0f;//当前抓的目标位置Y
    private float m_modelCompassTopPosY = 1.18f;//指南针//0.2
    private float m_modelBinocularTopPosY = 1.17f;//望远镜//0.44
    private float m_modelTorchTopPosY = 1.47f;//手电筒//0.36
    private float m_modelCompassOverPosY = 0.98f;//溢出高度
    private float m_modelBinocularOverPosY = 0.73f;//溢出高度
    private float m_modelTorchOverPosY = 1.11f;//溢出高度
    private string m_modelCompassStr = "Compass";
    private string m_modelTorchStr = "Torch";
    private string m_modelBinocularStr = "Binocular";
    private string m_modelBallStr = "Ball";
    private Vector3 m_hitBoxPoint = Vector3.zero;//碰到箱子的点
    private bool m_bControlCollisionBox = true;
    private int m_insideBoxNum = 0;
    private bool m_bResult = true;
    private int m_hitTopBoxNum = 0;
    public int hitTopBoxNum => m_hitTopBoxNum;
    private Rigidbody[] m_fixedRigidBody;
    private int m_TotalNum = 4;//总的道具数量
    private MeshCollider m_meshCollider;//自身碰撞网格
    private float m_boxHeight = 0.0f;//盒子高度
    // Start is called before the first frame update
    void Start()
    {
        m_targetTrans = m_targetParentTrans.GetComponentsInChildren<MeshCollider>();

        for (int i = 0; i < m_targetTrans.Length; i++)
        {
            m_dicBox.Add(m_targetTrans[i], false);
            m_dicInsideBox.Add(m_targetTrans[i], false);
            m_dicInsideCollisonBox.Add(m_targetTrans[i], false);
            m_dicPos.Add(m_targetTrans[i], m_targetTrans[i].transform.position.y);
            m_dicMat.Add(m_targetTrans[i], m_targetTrans[i].GetComponent<MeshRenderer>().materials);
            m_dicRotate.Add(m_targetTrans[i],m_targetTrans[i].transform.rotation);
        }
        m_camera = Camera.main;
        GameServices.inputService.pad.onTouchUp += OnTouchUp;
        //m_animator = GetComponent<Animator>();
        if(m_fixedTrans)
        {
            m_fixedRigidBody = m_fixedTrans.GetComponentsInChildren<Rigidbody>();
        }
        m_meshCollider = GetComponent<MeshCollider>();
        m_TotalNum = GlobalConfig.TotalNum();
        m_boxHeight = GlobalConfig.BoxHeight();
    }
    void CancelInvoke()
    {
        if(IsInvoking("DelayClearInsideState"))
        {
            CancelInvoke("DelayClearInsideState");
        }
    }
    //延迟处理
    void DelayClearInsideState()
    {
        if (m_curTargetTrans && m_dicInsideCollisonBox.ContainsKey(m_curTargetTrans))
        {
            m_dicInsideCollisonBox[m_curTargetTrans] = false;
        }
    }
    private void OnTriggerEnter(Collider other)
    {
        if (other.gameObject.CompareTag("Target") && m_curTargetTrans /*&& m_bControlCollisionBox*/)
        {
            //m_bControlCollisionBox = false;
            //if (m_dicInsideBox.ContainsKey(m_curTargetTrans) && m_dicInsideBox[m_curTargetTrans])
            //{
            //    m_curTargetTrans.transform.Rotate(transform.up, 90.0f);
            //    MeshCollider varBox = other.gameObject.GetComponent<MeshCollider>();
            //    if (m_dicInsideCollisonBox.ContainsKey(varBox))
            //    {
            //        m_dicInsideCollisonBox[varBox] = true;
            //    }
            //    CancelInvoke();
            //    Invoke("DelayResetInsideState", 0.05f);
            //}
            //else
            {
                MeshCollider varBox = other.gameObject.GetComponent<MeshCollider>();
                if (m_dicBox.ContainsKey(varBox))
                {
                    m_dicBox[varBox] = true;
                }
            }
        }
    }
    private void OnTriggerExit(Collider other)
    {
        //if (other.gameObject.CompareTag("Target") && m_curTargetTrans && !m_bControlCollisionBox)
        //{
        //    m_bControlCollisionBox = true;
        //    m_hitBoxPoint = other.ClosestPoint(other.transform.position);
        //    //if (m_dicInsideBox.ContainsKey(m_curTargetTrans) && m_dicInsideBox[m_curTargetTrans])
        //    //{
        //    //    MeshCollider varBox = other.gameObject.GetComponent<MeshCollider>();
        //    //    if (m_dicInsideCollisonBox.ContainsKey(varBox))
        //    //    {
        //    //        m_dicInsideCollisonBox[varBox] = false;
        //    //    }
        //    //}
        //    //else
        //    {
        //        //MeshCollider varBox = other.gameObject.GetComponent<MeshCollider>();
        //        //if (m_dicBox.ContainsKey(varBox))
        //        //{
        //        //    m_dicBox[varBox] = false;
        //        //}
        //    }
        //}
    }
    //放入箱子里面
    public void InsideBox(Collider other)
    {
        //MeshCollider varBox = other.gameObject.GetComponent<MeshCollider>();
        //if (m_dicInsideBox.ContainsKey(varBox))
        //{
        //    m_dicInsideBox[varBox] = true;
        //}
        //Rigidbody varBody = other.gameObject.GetComponent<Rigidbody>();
        //if (varBody)
        //{
        //    varBody.isKinematic = true;
        //}
        m_insideBoxNum++;
        BattleCtrl.instance.battleUI.SetTakeBtnState(m_insideBoxNum >= m_TotalNum);
    }
    //从箱子拿出
    public void ExitBox()
    {
        m_insideBoxNum--;
        BattleCtrl.instance.battleUI.SetTakeBtnState(m_insideBoxNum >= m_TotalNum);
    }
    //碰到顶部盒子
    public void EnterTopBox(string name)
    {
        for (int i = 0; i < m_targetTrans.Length; i++)
        {
            if (string.Equals(m_targetTrans[i].name, name))
            {
                if(BattleCtrl.instance.battleUI.isDebug)
                {
                    Material[] varMat = m_targetTrans[i].GetComponent<MeshRenderer>().materials;
                    Material[] varM = new Material[varMat.Length];
                    for (int m = 0;m< varMat.Length;m++)
                    {
                        varM[m] = m_redMat;
                    }
                    m_targetTrans[i].GetComponent<MeshRenderer>().materials = varM;
                }
                else
                {
                    //Material[] varMat = m_targetTrans[i].GetComponent<MeshRenderer>().materials;
                    //Material[] varM = new Material[varMat.Length];
                    //for (int m = 0; m < varMat.Length; m++)
                    //{
                    //    varM[m] = (m_dicMat[m_targetTrans[i]][m]);
                    //}
                    //m_targetTrans[i].GetComponent<MeshRenderer>().materials = varM;
                }
                m_hitTopBoxNum++;
                break;
            }
        }
        //Debug.LogError(m_hitTopBoxNum);
    }
    //退出顶部盒子
    public void ExitTopBox(string name)
    {
        for (int i = 0; i < m_targetTrans.Length; i++)
        {
            if (string.Equals(m_targetTrans[i].name, name))
            {
                if (BattleCtrl.instance.battleUI.isDebug)
                {
                    Material[] varMat = m_targetTrans[i].GetComponent<MeshRenderer>().materials;
                    Material[] varM = new Material[varMat.Length];
                    for (int m = 0; m < varMat.Length; m++)
                    {
                        varM[m] = m_dicMat[m_targetTrans[i]][m];
                    }
                    m_targetTrans[i].GetComponent<MeshRenderer>().materials = varM;
                }
                m_hitTopBoxNum--;
                break;
            }
        }
        //Debug.LogError(m_hitTopBoxNum);
    }
    //退出箱子碰到处理
    void UpdateExitBox()
    {
        if(m_bControlCollisionBox && m_hitBoxPoint != Vector3.zero)
        {
            if(m_curTargetTrans && Vector3.SqrMagnitude(m_curTargetTrans.transform.position - m_hitBoxPoint) >= 0.8f)
            {
                m_hitBoxPoint = Vector3.zero;
                if (m_dicBox.ContainsKey(m_curTargetTrans))
                {
                    m_dicBox[m_curTargetTrans] = false;
                }
            }
        }
    }
    //invoke旋转
    void RotateInvoke()
    {
        CancelRotateInvoke();
        InvokeRepeating("RotateTarget", 0.5f, Time.deltaTime);
    }
    //取消invoke
    void CancelRotateInvoke()
    {
        if (IsInvoking("RotateTarget"))
        {
            CancelInvoke("RotateTarget");
        }
    }
    void RotateTarget()
    {
        if (m_curTargetTrans)
        {
            m_curTargetTrans.transform.localRotation = Quaternion.Euler(m_dicRotate[m_curTargetTrans].eulerAngles.x,
                m_curTargetTrans.transform.rotation.eulerAngles.y + m_rotateSpeed, m_dicRotate[m_curTargetTrans].eulerAngles.z);
            //m_curTargetTrans.transform.Rotate(transform.up, m_rotateSpeed);
        }
    }
    //设置结果动画
    public void SetResultAnimator(bool value)
    {
        //for (int i = 0; i < m_targetTrans.Length; i++)
        //{
        //    m_targetTrans[i].GetComponent<Rigidbody>().constraints = RigidbodyConstraints.FreezeRotationX | RigidbodyConstraints.FreezeRotationY
        //                                       | RigidbodyConstraints.FreezeRotationZ;
        //}
        if (value)
        {
            for (int i = 0; i < m_targetTrans.Length; i++)
            {
                m_targetTrans[i].GetComponent<Rigidbody>().isKinematic = true;
            }
            if(m_animator)
            {
                string varStr = GlobalConfig.WinAnimatorName();
                m_animator.Play(varStr);
            }
        }
        else
        {
            if (m_fixedRigidBody != null)
            {
                for (int i = 0; i < m_fixedRigidBody.Length; i++)
                {
                    m_fixedRigidBody[i].isKinematic = false;
                }
            }
            m_bResult = false;
            m_planeObj.SetActive(false);
            if(m_animator)
            {
                string varStr = GlobalConfig.FailAnimatorName();
                m_animator.Play(varStr);
            }
        }
    }
    void Update()
    {
        if (!BattleCtrl.instance.isStartBattle)
        {
            return;
        }
        if (Input.GetMouseButtonDown(0))
        {
            Clicked();
        }
        if (Input.GetMouseButton(0))
        {
            Vector3 varVec3 = Input.mousePosition;
            varVec3.x = (varVec3.x - Screen.width / 2f) / (Screen.width / GlobalConfig.NormalWidth) + 100;
            varVec3.y = (varVec3.y - Screen.height / 2f) / (Screen.width / GlobalConfig.NormalWidth) - 100;
            BattleCtrl.instance.battleUI.SetMousePos(varVec3.x, varVec3.y);
            if (m_curTargetTrans)
            {
                //if (m_dicInsideCollisonBox.ContainsKey(m_curTargetTrans) && !m_dicInsideCollisonBox[m_curTargetTrans])
                {
                    m_targetScreenVec = Camera.main.WorldToScreenPoint(m_curTargetTrans.transform.position);
                    m_curTargetTrans.transform.position = Camera.main.ScreenToWorldPoint(new Vector3(Input.mousePosition.x,
                    Input.mousePosition.y, m_targetScreenVec.z));
                    //十字架位置
                    float varX = (Input.mousePosition.x - Screen.width / 2f) / (Screen.width / GlobalConfig.NormalWidth);
                    float varY = (Input.mousePosition.y - Screen.height / 2f) / (Screen.width / GlobalConfig.NormalWidth);
                    BattleCtrl.instance.battleUI.SetSymbolPos(varX, varY);
                    //if(string.Equals(m_curTargetTrans.name, m_modelBallStr))
                    //{
                    //    m_curTargetTrans.transform.localScale = Vector3.Lerp(m_curTargetTrans.transform.localScale, Vector3.one * 4, 0.2f);
                    //}
                    //else
                    //{
                    //    m_curTargetTrans.transform.localScale = Vector3.Lerp(m_curTargetTrans.transform.localScale, Vector3.one * 10, 0.2f);
                    //}
                }
            }
        }
        else if (Input.GetMouseButtonUp(0))
        {
            BattleCtrl.instance.battleUI.SetMousePos(0, 0);
        }
        //确保最低位置
        if (m_curTargetTrans)
        {
            Vector3 varPos = m_curTargetTrans.transform.position;
            if (m_dicBox.ContainsKey(m_curTargetTrans) && m_dicBox[m_curTargetTrans])
            {
                //if (m_collisonTargetTrans && m_bIsCollisonTarget)
                //{
                //    varPos.y = m_collisonTargetTrans.localPosition.y + 1.0f;//+ m_collisonTargetTrans.localScale.y;
                //}
                //else
                {
                    if (m_dicPos.ContainsKey(m_curTargetTrans))
                    {
                        varPos.y = m_dicPos[m_curTargetTrans]+ m_boxHeight;
                    }
                    //if (string.Equals(m_curTargetTrans.name, m_modelTorchStr))
                    //{
                    //    varPos.y = m_modelTorchTopPosY;
                    //}
                    //else if(string.Equals(m_curTargetTrans.name, m_modelBinocularStr))
                    //{
                    //    varPos.y = m_modelBinocularTopPosY;
                    //}
                    //else if(string.Equals(m_curTargetTrans.name, m_modelCompassStr))
                    //{
                    //    varPos.y = m_modelCompassTopPosY;
                    //}
                }
            }
            else
            {
                if (m_collisonTargetTrans && m_bIsCollisonTarget)
                {
                    varPos.y = m_collisonTargetTrans.localPosition.y + 1.0f;//+ m_collisonTargetTrans.localScale.y;
                }
                else
                {
                    if(m_dicPos.ContainsKey(m_curTargetTrans))
                    {
                        varPos.y = m_dicPos[m_curTargetTrans];
                    }
                }
            }
            if (varPos.y < m_dicPos[m_curTargetTrans])
            {
                varPos.y = m_dicPos[m_curTargetTrans];
            }
            m_curTargetTrans.transform.position = varPos;
        }
        if (m_bIsHitTarget)
        {
            m_bIsHitTarget = false;
            if (m_animator)
            {
                m_animator.enabled = true;
            }
            Invoke("SetTargetParent", 1.0f);
            //m_camera.transform.position = Vector3.Lerp(m_camera.transform.position, m_cameraTargetPos, 0.2f);
            //m_camera.transform.rotation = Quaternion.Lerp(m_camera.transform.rotation, m_cameraTargetRotate, 0.2f);
        }
        if(m_bResult)
        {
            for (int i = 0; i < m_targetTrans.Length; i++)
            {
                Vector3 varPos = m_targetTrans[i].transform.position;
                if (varPos.y < m_dicPos[m_targetTrans[i]])
                {
                    varPos.y = m_dicPos[m_targetTrans[i]];
                }
                m_targetTrans[i].transform.position = varPos;
            }
        }
        //UpdateExitBox();
    }
    //设置父节点
    void SetTargetParent()
    {
        m_targetParentTrans.SetParent(m_parent/*transform.GetChild(0)*/);
    }
    // 抬起回调
    void OnTouchUp()
    {
        if (m_curTargetTrans)
        {
            MeshCollider varBox = m_curTargetTrans.GetComponent<MeshCollider>();
            if (m_dicBox.ContainsKey(varBox))
            {
                m_dicBox[varBox] = false;
            }
            Rigidbody varBody = m_curTargetTrans.GetComponent<Rigidbody>();
            varBody.constraints = RigidbodyConstraints.None;
            varBody.isKinematic = false;
            m_curTargetTrans = null;
        }
        m_collisonTargetTrans = null;
        m_bIsCollisonTarget = false;
        BattleCtrl.instance.battleUI.SetSymbolPos(0, 0);
        //CancelDelayMatChangeHandle();
        //Invoke("DelayMatChangeHandle", 0.5f);
        CancelRotateInvoke();
    }
    void CancelDelayMatChangeHandle()
    {
        if (IsInvoking("DelayMatChangeHandle"))
        {
            CancelInvoke("DelayMatChangeHandle");
        }
    }
    //延时判断是否需要变化材质球
    void DelayMatChangeHandle()
    {
        bool varBool_ = true;
        for (int i = 0; i < m_targetTrans.Length; i++)
        {
            if(m_targetTrans[i].GetComponent<MeshRenderer>().sharedMaterial == m_redMat)
            {
                varBool_ = false;
                break;
            }
        }
        BattleCtrl.instance.battleUI.SetResultState(varBool_);
        //bool varBool_ = true;
        //for (int i = 0; i < m_targetTrans.Length; i++)
        //{
        //    if (string.Equals(m_targetTrans[i].name, m_modelTorchStr))
        //    {
        //        if(m_targetTrans[i].transform.position.y >= m_modelTorchOverPosY)
        //        {
        //            m_targetTrans[i].GetComponent<MeshRenderer>().sharedMaterial = m_redMat;
        //            varBool_ = false;
        //        }
        //        else
        //        {
        //            m_targetTrans[i].GetComponent<MeshRenderer>().sharedMaterial = m_dicMat[m_targetTrans[i]];
        //        }
        //    }
        //    else if (string.Equals(m_targetTrans[i].name, m_modelBinocularStr))
        //    {
        //        if (m_targetTrans[i].transform.position.y >= m_modelBinocularOverPosY)
        //        {
        //            m_targetTrans[i].GetComponent<MeshRenderer>().sharedMaterial = m_redMat;
        //            varBool_ = false;
        //        }
        //        else
        //        {
        //            m_targetTrans[i].GetComponent<MeshRenderer>().sharedMaterial = m_dicMat[m_targetTrans[i]];
        //        }
        //    }
        //    else if (string.Equals(m_targetTrans[i].name, m_modelCompassStr))
        //    {
        //        if (m_targetTrans[i].transform.position.y >= m_modelCompassOverPosY)
        //        {
        //            m_targetTrans[i].GetComponent<MeshRenderer>().sharedMaterial = m_redMat;
        //            varBool_ = false;
        //        }
        //        else
        //        {
        //            m_targetTrans[i].GetComponent<MeshRenderer>().sharedMaterial = m_dicMat[m_targetTrans[i]];
        //        }
        //    }
        //}
        //BattleCtrl.instance.battleUI.SetResultState(varBool_);
    }
    //碰到其他目标
    public void SetTargetCollison(Transform trans, bool bool_)
    {
        m_collisonTargetTrans = trans;
        m_bIsCollisonTarget = bool_;
    }
    void Clicked()
    {
        m_triggerBox.gameObject.SetActive(false);
        m_triggerTopBox.gameObject.SetActive(false);
        if(m_meshCollider)
        {
            m_meshCollider.enabled = false;
        }
        Ray ray = Camera.main.ScreenPointToRay(Input.mousePosition);

        RaycastHit hit = new RaycastHit();

        if (Physics.Raycast(ray, out hit))
        {
            if (hit.collider && hit.collider.gameObject.CompareTag("Target"))
            {
                m_bIsHitTarget = true;
                //for (int i = 0; i < m_targetTrans.Length; i++)
                //{
                //    m_targetTrans[i].GetComponent<Rigidbody>().isKinematic = true;
                //}
                for (int i = 0; i < m_targetTrans.Length; i++)
                {
                    if (string.Equals(hit.collider.name, m_targetTrans[i].name))
                    {
                        m_curTargetTrans = m_targetTrans[i];
                        Rigidbody varBody = m_curTargetTrans.GetComponent<Rigidbody>();
                        varBody.isKinematic = true;
                        //varBody.collisionDetectionMode = CollisionDetectionMode.Discrete;
                        varBody.constraints = RigidbodyConstraints.FreezeRotationX | RigidbodyConstraints.FreezeRotationY
                                               | RigidbodyConstraints.FreezeRotationZ;
                        //Quaternion varQua = m_curTargetTrans.transform.rotation;
                        //varQua.x = m_dicRotate[m_curTargetTrans].eulerAngles.x;
                        //varQua.z = m_dicRotate[m_curTargetTrans].eulerAngles.z;
                        m_curTargetTrans.transform.rotation = Quaternion.Euler(m_dicRotate[m_curTargetTrans].eulerAngles.x,
                            m_curTargetTrans.transform.eulerAngles.y, m_dicRotate[m_curTargetTrans].eulerAngles.z);

                        m_triggerBox.gameObject.SetActive(true);
                        m_triggerTopBox.gameObject.SetActive(true);
                        if (m_meshCollider)
                        {
                            m_meshCollider.enabled = true;
                        }
                        //m_curTargetPosY = m_curTargetTrans.transform.position.y;
                        Invoke("DelayInvokeRigidBody", 0.1f);
                        //CancelDelayMatChangeHandle();
                        if (m_dicMat.ContainsKey(m_curTargetTrans))
                        {
                            if (BattleCtrl.instance.battleUI.isDebug)
                            {
                                Material[] varMat = m_curTargetTrans.GetComponent<MeshRenderer>().materials;
                                Material[] varM = new Material[varMat.Length];
                                for (int m = 0; m < varMat.Length; m++)
                                {
                                    varM[m] = m_dicMat[m_targetTrans[i]][m];
                                }
                                m_curTargetTrans.GetComponent<MeshRenderer>().materials = varM;
                            }
                        }
                        RotateInvoke();
                        SecondLevelTrigger varTrigger = m_triggerTopBox.GetComponent<SecondLevelTrigger>();
                        if (varTrigger)
                        {
                            varTrigger.SetExit(m_curTargetTrans);
                        }
                        break;
                    }
                }
                m_targetScreenVec = Camera.main.WorldToScreenPoint(m_curTargetTrans.transform.position);
                //偏移值=物体的世界坐标，减去转化之后的鼠标世界坐标（z轴的值为物体屏幕坐标的z值）
                m_offset = m_curTargetTrans.transform.position - Camera.main.ScreenToWorldPoint(new Vector3
                (Input.mousePosition.x, Input.mousePosition.y, m_targetScreenVec.z));
            }
        }
    }
    //延迟处理
    void DelayInvokeRigidBody()
    {
        //for (int i = 0; i < m_targetTrans.Length; i++)
        //{
        //    Rigidbody varBody = m_targetTrans[i].GetComponent<Rigidbody>();
        //    if (m_curTargetTrans && m_curTargetTrans != m_targetTrans[i])
        //    {
        //        varBody.isKinematic = false;
        //    }
        //}
    }
    private void OnDestroy()
    {
        m_targetTrans = null;
        m_curTargetTrans = null;
        if (GameServices.inputService != null)
        {
            GameServices.inputService.pad.onTouchUp -= OnTouchUp;
        }
        //CancelDelayMatChangeHandle();
        CancelRotateInvoke();
    }
}
