﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class SettingPanel : MonoBehaviour
{
    public Button m_vibrationBtn;//震动按钮
    public Button m_soundBtn;//音效按钮
    public Button m_bgmBtn;//背景音乐按钮
    public GameObject m_vibrationImageObj;//震动✔
    public GameObject m_soundImageObj;//音效✔
    public GameObject m_bgmImageObj;//背景音乐✔
    public GameObject m_settingObj;//设置按钮
    private void Awake()
    {
        m_vibrationBtn.onClick.AddListener(OnVibrationClick);
        m_soundBtn.onClick.AddListener(OnSoundClick);
        m_bgmBtn.onClick.AddListener(OnBgmClick);
    }
    private void Start()
    {
        string varStr1 = GlobalConfig.VibrationKey;
        if (LocalRecord.HasKey(varStr1))
        {
            m_vibrationImageObj.SetActive(LocalRecord.GetIntRecord(varStr1) > 0 ? true : false);
        }
        else
        {
            m_vibrationImageObj.SetActive(true);
        }
        string varStr2 = GlobalConfig.SoundKey;
        if (LocalRecord.HasKey(varStr2))
        {
            m_soundImageObj.SetActive(LocalRecord.GetIntRecord(varStr2) > 0 ? true : false);
        }
        else
        {
            m_soundImageObj.SetActive(true);
        }
        string varStr3 = GlobalConfig.BgmKey;
        if (LocalRecord.HasKey(varStr3))
        {
            m_bgmImageObj.SetActive(LocalRecord.GetIntRecord(varStr3) > 0 ? true : false);
        }
        else
        {
            m_bgmImageObj.SetActive(false);
        }
    }
    //震动
    void OnVibrationClick()
    {
        bool varBool = m_vibrationImageObj.activeSelf;
        m_vibrationImageObj.SetActive(!varBool);
        LocalRecord.SetIntRecord(GlobalConfig.VibrationKey, varBool ? 0 : 1);
    }
    //音效
    void OnSoundClick()
    {
        bool varBool = m_soundImageObj.activeSelf;
        m_soundImageObj.SetActive(!varBool);
        LocalRecord.SetIntRecord(GlobalConfig.SoundKey, varBool ? 0 : 1);
    }
    //背景音乐
    void OnBgmClick()
    {
        bool varBool = m_bgmImageObj.activeSelf;
        m_bgmImageObj.SetActive(!varBool);
        LocalRecord.SetIntRecord(GlobalConfig.BgmKey, varBool ? 0 : 1);
        if(varBool)
        {
            GameServices.audioServices.RecycleBgm();
        }
        else
        {
            GameServices.audioServices.PlayBgm(GameServices.configService.audioConfig.GameBgm);
        }
    }
    public void OnCloseClick()
    {
        m_settingObj.SetActive(false);
        gameObject.SetActive(false);
        BattleCtrl.instance.battleUI.SetBattleObjState(true);
        BattleCtrl.instance.battleUI.SettingBtnState(false);
    }
}
