﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class SecondLevelTrigger : MonoBehaviour
{
    private bool m_bControl = true;
    private void OnTriggerEnter(Collider other)
    {
        if (other.gameObject.CompareTag("Target") && m_bControl)
        {
            m_bControl = false;
            StorageView varView = BattleCtrl.instance.levelManager.curLevel.storageView;
            if(varView)
            {
                varView.EnterTopBox(other.name);
            }
        }
    }
    private void OnTriggerExit(Collider other)
    {
        if (other.gameObject.CompareTag("Target") && !m_bControl)
        {
            m_bControl = true;
            StorageView varView = BattleCtrl.instance.levelManager.curLevel.storageView;
            if (varView)
            {
                varView.ExitTopBox(other.name);
            }
        }
    }
}
