﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class FollowTarget : MonoBehaviour
{
    //游戏人物 的位置
    public Transform player;

    //游戏人物与 相机的差
    public Vector3 offset;
    private bool m_bTrun = false;//是否转弯
    private Rigidbody m_rigidbody;
    // Use this for initialization
    void Start()
    {
        //offset = transform.position - player.position;
        m_rigidbody = GetComponent<Rigidbody>();
    }


    // Update is called once per frame
    void FixedUpdate()
    {
        m_rigidbody.velocity.Normalize();

        // Save transform localy
        Quaternion curRot = transform.rotation;
        Vector3 tPos = player.position + player.TransformDirection(offset);

        // Look at the target
        transform.LookAt(player);
        
        // Keep the camera above the target y position
        if (tPos.y < player.position.y)
        {
            tPos.y = player.position.y;
        }
        // Set transform with lerp
        transform.position = Vector3.Lerp(transform.position, tPos, Time.fixedDeltaTime * 4);
        transform.rotation = Quaternion.Lerp(curRot, transform.rotation, Time.fixedDeltaTime * 6);

        // Keep camera above the y:0.5f to prevent camera going underground
        if (transform.position.y < 0.5f)
        {
            transform.position = new Vector3(transform.position.x, 0.5f, transform.position.z);
        }
        //UpdateTurn();
    }
    //开始拐弯
    public void SetTurn()
    {
        m_bTrun = true;
    }
    void UpdateTurn()
    {
        if (m_bTrun)
        {
            transform.localRotation = Quaternion.Lerp(transform.localRotation, Quaternion.Euler(transform.localEulerAngles.x, 270, transform.localEulerAngles.z), 0.2f);
        }
    }

}
