using UnityEngine;
using UnityEngine.Events;
using UnityEngine.EventSystems;
using System.Collections;

public class RepeatPressEventTrigger : MonoBehaviour, IPointerDownHandler, IPointerUpHandler, IPointerExitHandler
{
    public float interval = 0.05f;//0.1f;
    public float longPeriod = 0.6f;//1f;

    [SerializeField]
    UnityEvent m_OnLongpress = new UnityEvent();


    private bool isPointDown = false;
    private float lastInvokeTime;
    private float clickDownTime;

    // Use this for initialization
    void Start()
    {
    }

    // Update is called once per frame
    void Update()
    {
        if (isPointDown && Time.time - clickDownTime > longPeriod)
        {
            if (Time.time - lastInvokeTime > interval)
            {
                //触发点击;
                m_OnLongpress.Invoke();
                lastInvokeTime = Time.time;
            }
        }

    }

    public void OnPointerDown(PointerEventData eventData)
    {
        m_OnLongpress.Invoke();

        isPointDown = true;

        lastInvokeTime = Time.time;
        clickDownTime = lastInvokeTime;
    }

    public void OnPointerUp(PointerEventData eventData)
    {
        isPointDown = false;
    }

    public void OnPointerExit(PointerEventData eventData)
    {
        isPointDown = false;
    }
}