﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class FirstLevelTrigger : MonoBehaviour
{
    //public Transform m_targetTrans;
    private Vector3 m_pos = new Vector3(-1.61f, 0.22f, 0);
    private Quaternion m_rotation = Quaternion.identity;
    private bool m_bControl = true;
    private Transform m_targetTrans;

    //private void OnTriggerEnter(Collider other)
    //{
    //    if (other.gameObject.CompareTag("Target"))
    //    {
    //        BattleCtrl.instance.levelManager.curLevel.chainRopeView.CatchObjEnterTarget();
    //        BattleCtrl.instance.OnBattleWin();
    //        m_targetTrans.localPosition = m_pos;
    //        m_targetTrans.localRotation = m_rotation;
    //    }
    //}
    protected virtual void OnTriggerEnter(Collider collider)
    {
        Rigidbody rb = collider.GetComponent<Rigidbody>();
        if (collider.gameObject.CompareTag("Target") && m_bControl && rb)
        {
            m_bControl = false;
            m_targetTrans = collider.transform;
            rb.constraints = RigidbodyConstraints.FreezePositionX | RigidbodyConstraints.FreezePositionY | RigidbodyConstraints.FreezePositionZ |
                                              RigidbodyConstraints.FreezeRotationX | RigidbodyConstraints.FreezeRotationY;
            BattleCtrl.instance.OnBattleWin();
        }
    }
    private void Update()
    {
        if(!m_bControl && m_targetTrans)
        {
            m_targetTrans.localPosition = Vector3.Lerp(m_targetTrans.localPosition, m_pos, 0.03f);
        }
    }
}
