﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using Obi;
using System.Runtime.InteropServices;
using System;
using UnityEngine.UI;
using EPOOutline;
//using MoreMountains.NiceVibrations;

public class ChainRopeView : MonoBehaviour
{
    [DllImport("user32")]
    public static extern void mouse_event(int flags, int dx, int dy, uint data, UIntPtr extraInfo);
    //模拟鼠标左键按下 
    public const int MOUSEEVENTF_LEFTDOWN = 0x0002;
    public ObiSolver solver;
    public ObiCollider character;
    public float hookExtendRetractSpeed = 2;
    public Material material;
    public ObiRopeSection section;
    public Collider m_topCollider;//顶部连接的
    public Transform m_leftClawTrans;//左爪
    public Transform m_rightClawTrans;//右爪
    public Transform m_threeClawTrans;//第三爪
    public Transform m_clawBody;//爪身
    public Transform leftClawTrans => m_leftClawTrans;
    public Transform m_lightObj;

    public OnDelegateArg0 onBalloonEnterTarget;//气球碰到目标回调或者被爪子抓住
    public OnDelegateArg0 onBalloonEnterGround;//气球碰到地面回调
    public OnDelegateArg0 onBalloonEnterSuccessTarget;//气球碰到胜利目标

    private ObiRope rope;
    private ObiRopeBlueprint blueprint;
    private ObiRopeExtrudedRenderer ropeRenderer;

    private ObiRopeCursor cursor;

    private RaycastHit hookAttachment;
    private bool m_bIsCatch = false;//是否抓住
    public bool IsCatch => m_bIsCatch;
    private bool m_bControlTouchUp = false;//控制松开
    private TargetView m_targetView;//目标碰撞view
    private GameObject m_leftTargetObj;//左边碰撞的obj
    private GameObject m_rightTargetObj;//右边碰撞的obj
    private GameObject m_threeTargetObj;//第三爪碰撞的obj
    private bool m_bFirstMoveUp = false;//是否第一移动完松手
    private float m_addAngleSpeed = 0.0f;//角度增加的速度
    private bool m_bIsMaxAngle = true;//是否旋转到最大角度
    private bool m_bIsHitLeftClaw = false;//是否撞到左爪
    private bool m_bIsHitRightClaw = false;//是否撞到右爪
    private bool m_bIsHitThreeClaw = false;//是否碰到第三爪
    private bool m_bPress = false;//是否按下
    private bool m_bColliderTarget = false;//是否碰到目标
    private float m_ropeStartLength = 0.0f;//绳子开始的长度
    private Vector3 m_lightObjPos;//光圈位置
    private Rigidbody m_rigidBody;
    private float m_leftClawStartRatateY;//初始位置
    private float m_rightClawStartRatateY;//初始位置
    private float m_threeClawStartRatateY;//初始位置
    private bool m_bIsNeedRotate = true;//是否需要旋转；
    private float m_clawBodyAngleSpeed = 0;//爪身旋转速度
    private bool m_bCatchTouchUp = false;//抓住目标后松手
    public bool CatchTouchUp => m_bCatchTouchUp;
    private bool m_bIsCathchObjHitTarget = false;//是否抓住的物体碰到目标
    private float m_topColliderPosY;//顶部的位置Y
    private bool m_bControlUnHook = true;//控制脱钩
    private bool m_bIsDragMode = true;//是否拖动模式
    private Vector3 m_topColliderScreenPos;//顶部屏幕的位置
    private RectTransform m_thumbRT;//摇杆
    private Outlinable m_outlinable;//插件脚本
    private bool m_bIsClawUp = false;//是否爪子在上升
    //private AudioSource m_clawDownOrUpAudioSource;//下降上升音乐，需要循环播放
    private bool m_bControlPlayAudio = true;//控制播放音效
    private float m_MoveLimitY;//移动区域
    
    void Awake()
    {
        // Create both the rope and the solver:	
        rope = gameObject.AddComponent<ObiRope>();
        ropeRenderer = gameObject.AddComponent<ObiRopeExtrudedRenderer>();
        ropeRenderer.section = section;
        ropeRenderer.uvScale = new Vector2(1, 5);
        ropeRenderer.normalizeV = false;
        ropeRenderer.uvAnchor = 1;
        rope.GetComponent<MeshRenderer>().material = material;

        // Setup a blueprint for the rope:
        blueprint = ScriptableObject.CreateInstance<ObiRopeBlueprint>();
        blueprint.resolution = 0.5f;

        // Tweak rope parameters:
        rope.maxBending = 0.02f;

        // Add a cursor to be able to change rope length:
        cursor = rope.gameObject.AddComponent<ObiRopeCursor>();
        cursor.cursorMu = 0;
        cursor.direction = true;
        m_lightObjPos = m_lightObj.localPosition;
        m_rigidBody = character.gameObject.GetComponent<Rigidbody>();
        m_topColliderPosY = m_topCollider.transform.localPosition.y;
        m_outlinable = gameObject.GetComponent<Outlinable>();

        StartCoroutine(AttachHook());
        m_MoveLimitY = Camera.main.WorldToScreenPoint(m_topCollider.transform.position).y;
    }
    private void Start()
    {
        GameServices.inputService.pad.onMoveVec3 += OnMove;
        GameServices.inputService.pad.onTouchUp += OnTouchUp;
        GameServices.inputService.pad.onClickDown += OnClickDown;
        //GameServices.inputService.joyStick.JoystickMoveHandle += JoystickHandle;
        //GameServices.inputService.joyStick.JoystickEndHandle += JoystickEndHandle;
        SetJoyStickDirectTrans(m_topCollider.transform);
        //GameServices.inputService.joyStick.onTouchStart.AddListener(OnTouchStart);
        //GameServices.inputService.joyStick.onTouchUp.AddListener(OnTouchUp);
        m_leftClawStartRatateY = m_leftClawTrans.localEulerAngles.y;
        m_rightClawStartRatateY = m_rightClawTrans.localEulerAngles.y;
        //m_threeClawStartRatateY = m_threeClawTrans.localEulerAngles.y;
        m_addAngleSpeed = 0;//开始最大角度
        m_leftClawTrans.localRotation = Quaternion.Euler(0, m_leftClawStartRatateY, 0);
        m_rightClawTrans.localRotation = Quaternion.Euler(0, m_rightClawStartRatateY, 0);
        m_thumbRT = GameServices.inputService.joyStick.thumb;
        //m_threeClawTrans.localRotation = Quaternion.Euler(0, m_threeClawStartRatateY, m_addAngleSpeed);

        BattleCtrl.instance.battleUI.onClawMoveSpeedAddBtn = onClawMoveSpeedAddBtn;
        BattleCtrl.instance.battleUI.onClawMoveSpeedDownBtn = onClawMoveSpeedDownBtn;
    }
    //按下鼠标
    void OnClickDown()
    {
        float varX = Input.mousePosition.x - Screen.width / 2f;
        float varY = Input.mousePosition.y - Screen.height / 2f;
        BattleCtrl.instance.battleUI.SetMousePos(varX, varY);

    }
    void onClawMoveSpeedAddBtn()
    {
        GameServices.configService.playerConfig.ClawMoveSpeed -= Time.deltaTime;
    }
    void onClawMoveSpeedDownBtn()
    {
        GameServices.configService.playerConfig.ClawMoveSpeed += Time.deltaTime;
    }
    //移动
    void OnMove(Vector3 dir)
    {
        //移动区域
        if (Input.mousePosition.y > m_MoveLimitY)
        {
            return;
        }
        if (!BattleCtrl.instance.isStartBattle)
        {
            return;
        }
        //绳子最短才能移动
        if (rope.restLength > m_ropeStartLength)
        {
            return;
        }
        //第五关特殊处理
        //if(BattleCtrl.instance.levelManager.CurLevelIndex != LevelEnum.levelFiveIndex)
        {
            m_rigidBody.drag = 10;
            m_rigidBody.angularDrag = 10;
        }
        float varParamDis = Screen.width * GameServices.configService.playerConfig.ClawMoveSpeed / 2;//参数距离
        Vector3 varPos = m_topCollider.transform.position;
        //向左滑
        if (dir.x > 0)
        {
            varPos.x -= dir.x / varParamDis * GameServices.configService.playerConfig.xDirMaxDis;
        }
        //向右滑
        if(dir.x < 0)
        {
            varPos.x += dir.x / varParamDis * GameServices.configService.playerConfig.xDirMinDis;
        }
        //向上滑
        if(dir.y < 0)
        {
            varPos.z += dir.y / varParamDis * GameServices.configService.playerConfig.yDirMinDis;
        }
        //向下滑
        if(dir.y > 0)
        {
            varPos.z -= dir.y / varParamDis * GameServices.configService.playerConfig.yDirMaxDis;
        }
        varPos.y = m_topColliderPosY;
        m_topCollider.transform.position = varPos;
        //if (m_bIsDragMode)
        //{
        //    Vector3 varTopPos = Camera.main.WorldToScreenPoint(new Vector3(0, m_topCollider.transform.position.y, 0));
        //    Vector3 mousePosOnScreen = Input.mousePosition;
        //    mousePosOnScreen.z = varTopPos.z;
        //    Vector3 mousePosInWorld = Camera.main.ScreenToWorldPoint(mousePosOnScreen);
        //    m_topCollider.transform.position = new Vector3(mousePosInWorld.x, m_topColliderPosY, mousePosInWorld.y - 5.0f);
        //    return;
        //}
        ResetLightPos();
        //方式1
        //m_bFirstMoveUp = true;
        //m_bIsNeedRotate = !m_bIsCatch;
        //if (dir == Vector3.zero)
        //{
        //    return;
        //}
        //dir = dir * GameServices.configService.playerConfig.moveSpeed;

        ////transform.Translate(dir * Time.deltaTime, Space.World);
        //m_topCollider.transform.position = m_topCollider.transform.position + dir * Time.deltaTime;
    }
    //设置摇杆目标
    void SetJoyStickDirectTrans(Transform trans)
    {
        GameServices.inputService.joyStick.axisX.directTransform = trans;
        GameServices.inputService.joyStick.axisY.directTransform = trans;
    }
    void OnTouchStart()
    {
        //绳子最短才能移动
        if (rope.restLength > m_ropeStartLength)
        {
            return;
        }
        float varX = Input.mousePosition.x - Screen.width / 2f;
        float varY = Input.mousePosition.y - Screen.height / 2f;
        Vector2 varVec2 = GameServices.inputService.joyStick.gameObject.transform.localPosition;
        varVec2.x = varX;
        varVec2.y = varY;
        GameServices.inputService.joyStick.gameObject.transform.localPosition = varVec2;
        Vector2 varThumb = m_thumbRT.sizeDelta;
        varThumb.x = 80;
        varThumb.y = 80;
        m_thumbRT.sizeDelta = varThumb;
    }
    // 抬起回调
    void OnTouchUp()
    {
        //移动区域
        if (Input.mousePosition.y > m_MoveLimitY)
        {
            return;
        }
        if (!BattleCtrl.instance.isStartBattle)
        {
            return;
        }
        //第五关特殊处理
        //if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelFiveIndex)
        //{
        //    return;
        //}
        //方式1
        //if (m_bFirstMoveUp)
        //{
        //    m_bFirstMoveUp = false;
        //    return;
        //}
        m_rigidBody.drag = 1;
        m_rigidBody.angularDrag = 1;
        SetJoyStickDirectTrans(null);
        Vector2 varThumb = m_thumbRT.sizeDelta;
        varThumb.x = 4000;
        varThumb.y = 4000;
        m_thumbRT.sizeDelta = varThumb;
        if (rope.isLoaded && rope.restLength <= m_ropeStartLength)
        {
            m_bControlPlayAudio = true;
            //GameServices.audioServices.PlayAudio(GameServices.configService.audioConfig.clawDownOrUp);
            //PlayShake();
            //m_clawDownOrUpAudioSource = GameServices.audioServices.GetPlayAudioSource(GameServices.configService.audioConfig.clawDownOrUp);
            m_lightObj.SetParent(m_clawBody.parent.parent);
            if (m_bIsCatch)
            {
                //方式2
                m_bIsNeedRotate = false;
                m_bCatchTouchUp = true;
                //方式1
                //TouchUpEnd();
            }
            else
            {
                m_bIsNeedRotate = false;
                m_bPress = true;
                m_bIsMaxAngle = true;
            }
            m_bColliderTarget = false;
        }
        //下抓时可以随时点击暂停
        //else
        //{
        //    if (!m_bIsCatch && !m_bIsClawUp)
        //    {
        //        if(m_bPress)
        //        {
        //            m_bPress = false;
        //            m_bIsNeedRotate = true;
        //        }
        //        else 
        //        {
        //            m_bPress = true;
        //            m_bIsNeedRotate = false;
        //        }
        //    }
        //}
    }
    //震动
    void PlayShake()
    {
        if (!LocalRecord.HasKey(GlobalConfig.VibrationKey) || LocalRecord.GetIntRecord(GlobalConfig.VibrationKey) == 1)
        {
            //MMVibrationManager.Haptic(HapticTypes.HeavyImpact, false, true, this);
        }
    }
    //松手之后
    void TouchUpEnd()
    {
        m_bPress = false;
        m_bIsHitLeftClaw = false;
        m_bIsHitRightClaw = false;
        m_bIsHitThreeClaw = false;
        //方式2
        m_bCatchTouchUp = false;
        m_bIsCathchObjHitTarget = true;
        m_bColliderTarget = true;
        m_bIsMaxAngle = false;
        //方式1
        //m_bIsCatch = false;
        m_bIsNeedRotate = false;
        m_bControlTouchUp = true;
        GameServices.timerServices.Push(this, 0.5f, delegate
        {
            m_bControlTouchUp = false;
        });
        if (m_targetView)
        {
            m_targetView.AddRigidBody();
            m_leftTargetObj = null;
            m_rightTargetObj = null;
        }
    }
    //抓住之后脱钩了
    void ClawUnHook()
    {
        m_bPress = false;
        //方式2
        m_bCatchTouchUp = false;
        m_bIsCathchObjHitTarget = true;
        m_bColliderTarget = true;
        m_bIsMaxAngle = false;
        //方式1
        //m_bIsHitLeftClaw = false;
        //m_bIsHitRightClaw = false;
        //m_bIsHitThreeClaw = false;
        //m_bIsCatch = false;
        m_bIsNeedRotate = false;
        //m_bControlTouchUp = true;
        //GameServices.timerServices.Push(this, 0.5f, delegate
        //{
        //    m_bControlTouchUp = false;
        //});
        if (m_targetView)
        {
            m_targetView.AddRigidBody();
            m_leftTargetObj = null;
            m_rightTargetObj = null;
        }
    }
    //碰到左爪
    public void EnterLeftClaw(GameObject obj)
    {
        if (m_bControlTouchUp) return;//松手的时候不做碰撞判断
        m_leftTargetObj = obj;
        if (m_rightTargetObj && m_leftTargetObj.Equals(m_rightTargetObj))
        {
            m_targetView = obj.GetComponent<TargetView>();
        }
        m_bIsHitLeftClaw = true;
    }
    public void ExitLeftClaw()
    {
        m_bIsHitLeftClaw = false;
        if (!m_bIsHitRightClaw && !m_bIsHitLeftClaw)
        {
            m_bControlUnHook = true;
        }
    }
    //碰到右爪
    public void EnterRightClaw(GameObject obj)
    {
        if (m_bControlTouchUp) return;//松手的时候不做碰撞判断
        m_rightTargetObj = obj;
        if (m_leftTargetObj && m_rightTargetObj.Equals(m_leftTargetObj))
        {
            m_targetView = obj.GetComponent<TargetView>();
        }
        m_bIsHitRightClaw = true;
    }
    public void ExitRightClaw()
    {
        m_bIsHitRightClaw = false;
        if (!m_bIsHitRightClaw && !m_bIsHitLeftClaw)
        {
            m_bControlUnHook = true;
        }
    }
    //碰到第三爪
    public void EnterThreeClaw(GameObject obj)
    {
        if (m_bControlTouchUp) return;//松手的时候不做碰撞判断
        m_threeTargetObj = obj;
        if (m_leftTargetObj && m_rightTargetObj && m_threeTargetObj.Equals(m_leftTargetObj)
            && m_threeTargetObj.Equals(m_rightTargetObj))
        {
            m_targetView = obj.GetComponent<TargetView>();
        }
        m_bIsHitThreeClaw = true;
    }
    public void ExitThreeClaw()
    {
        m_bIsHitThreeClaw = false;
    }
    //碰到目标view
    public void EnterTargerView()
    {
        if (m_bControlTouchUp) return;//松手的时候不做碰撞判断
        if (!m_bColliderTarget)
        {
            m_bColliderTarget = true;
        }
        m_bPress = false;
    }
    //抓住的物体碰到目标
    public void CatchObjEnterTarget()
    {
        //方法1
        if (m_targetView)
        {
            TouchUpEnd();
            m_targetView.SetColliderSuccessTarget();
            m_targetView = null;
            //特殊处理
            if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelSixIndex)
            {
                onBalloonEnterTarget?.Invoke();
                onBalloonEnterSuccessTarget?.Invoke();
            }
        }
    }
    //抓住的物体碰到地面
    public void CatchObjEnterGround()
    {
        TouchUpEnd();
        //特殊处理
        if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelSixIndex)
        {
            onBalloonEnterGround?.Invoke();
        }
    }
    private void OnDestroy()
    {
        if (GameServices.inputService != null)
        {
            GameServices.inputService.pad.onMoveVec3 -= OnMove;
            GameServices.inputService.pad.onTouchUp -= OnTouchUp;
            GameServices.inputService.pad.onClickDown -= OnClickDown;
        }
        DestroyImmediate(blueprint);
        DetachHook();
        //if (m_clawDownOrUpAudioSource)
        //{
        //    GameServices.audioServices.AudioPlayFinished(m_clawDownOrUpAudioSource);
        //    m_clawDownOrUpAudioSource = null;
        //}
    }

    /**
	 * Raycast against the scene to see if we can attach the hook to something.
	 */
    private void LaunchHook()
    {

        // Get the mouse position in the scene, in the same XY plane as this object:
        Vector3 mouse = Input.mousePosition;
        mouse.z = transform.position.z - Camera.main.transform.position.z;
        Vector3 mouseInScene = Camera.main.ScreenToWorldPoint(mouse);

        // Get a ray from the character to the mouse:
        Ray ray = new Ray(transform.position, mouseInScene - transform.position);

        // Raycast to see what we hit:
        if (Physics.Raycast(ray, out hookAttachment))
        {

            // We actually hit something, so attach the hook!
            StartCoroutine(AttachHook());
        }

    }

    private IEnumerator AttachHook()
    {
        yield return 0;
        Vector3 localHit;
        //第五关特殊处理
        //if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelFiveIndex)
        //{
        //    localHit = new Vector3(0, 3, 0);
        //}
        //else
        {
            localHit = new Vector3(0, 0.5f, 0);//rope.transform.InverseTransformPoint(hookAttachment.point);
        }
        
        // Procedurally generate the rope path (a simple straight line):
        blueprint.path.Clear();
        blueprint.path.AddControlPoint(Vector3.zero, -localHit.normalized, localHit.normalized, Vector3.up, 0.1f, 0.1f, 1, 1, Color.white, "Hook start");
        blueprint.path.AddControlPoint(localHit, -localHit.normalized, localHit.normalized, Vector3.up, 0.1f, 0.1f, 1, 1, Color.white, "Hook end");
        blueprint.path.FlushEvents();

        // Generate the particle representation of the rope (wait until it has finished):
        //yield return blueprint.Generate();

        // Set the blueprint (this adds particles/constraints to the solver and starts simulating them).
        rope.ropeBlueprint = blueprint;
        rope.GetComponent<MeshRenderer>().enabled = true;

        // Pin both ends of the rope (this enables two-way interaction between character and rope):
        var pinConstraints = rope.GetConstraintsByType(Oni.ConstraintType.Pin) as ObiConstraints<ObiPinConstraintsBatch>;
        pinConstraints.Clear();
        var batch = new ObiPinConstraintsBatch();
        batch.AddConstraint(rope.solverIndices[0], character, transform.localPosition, Quaternion.identity, 0, 0, float.PositiveInfinity);
        batch.AddConstraint(rope.solverIndices[blueprint.activeParticleCount - 1], m_topCollider.GetComponent<ObiColliderBase>(),
                                                          new Vector3(0, -0.6f, 0), Quaternion.identity, 0, 0, float.PositiveInfinity);
        batch.activeConstraintCount = 2;
        pinConstraints.AddBatch(batch);

        rope.SetConstraintsDirty(Oni.ConstraintType.Pin);
        m_ropeStartLength = rope.restLength;

        m_outlinable.AddAllChildRenderersToRenderingList();
    }

    private void DetachHook()
    {
        // Set the rope blueprint to null (automatically removes the previous blueprint from the solver, if any).
        rope.ropeBlueprint = null;
        rope.GetComponent<MeshRenderer>().enabled = false;
    }
    //重置十字位置
    void ResetLightPos()
    {
        m_lightObj.SetParent(m_clawBody);
        m_lightObjPos.x = 0;
        m_lightObjPos.z = 0;
        m_lightObj.localPosition = m_lightObjPos;
        m_lightObj.localRotation = Quaternion.Euler(Vector3.zero);
    }

    void Update()
    {
        if(!BattleCtrl.instance.isStartBattle)
        {
            return;
        }
        if (Input.GetMouseButton(0))
        {
            //float varX = Input.mousePosition.x - Screen.width / 2f;
            //float varY = Input.mousePosition.y - Screen.height / 2f;
            //BattleCtrl.instance.battleUI.SetMousePos(varX, varY);
            Vector3 varVec3 = Camera.main.WorldToScreenPoint(m_topCollider.transform.position);
            varVec3.x = (varVec3.x - Screen.width / 2f)/ (Screen.width / GlobalConfig.NormalWidth) + 100;
            varVec3.y = (varVec3.y - Screen.height / 2f)/(Screen.width / GlobalConfig.NormalWidth) - 100;
            BattleCtrl.instance.battleUI.SetMousePos(varVec3.x, varVec3.y);
        }
        else if (Input.GetMouseButtonUp(0))
        {
            BattleCtrl.instance.battleUI.SetMousePos(0, 0);
        }
        //if(Input.GetMouseButtonDown(0))
        //{
        //    mouse_event(MOUSEEVENTF_LEFTDOWN, 0, 0, 0, UIntPtr.Zero);
        //}
        m_topCollider.transform.localPosition = new Vector3(Mathf.Clamp(m_topCollider.transform.localPosition.x, GameServices.configService.playerConfig.xDirMinDis, GameServices.configService.playerConfig.xDirMaxDis),
                                              m_topColliderPosY,
                                              Mathf.Clamp(m_topCollider.transform.localPosition.z, GameServices.configService.playerConfig.yDirMinDis, GameServices.configService.playerConfig.yDirMaxDis));
        float varMaxAngle = GameServices.configService.playerConfig.clawMaxAngle;
        float varRotateSpeed = GameServices.configService.playerConfig.clawRotateSpeed;
        if (m_bIsCatch)
        {
            //方式2
            if (m_bCatchTouchUp)
            {
                m_bIsClawUp = false;
                PlayShake();
                cursor.ChangeLength(rope.restLength + GameServices.configService.playerConfig.ropeExtendSpeed * Time.deltaTime);
            }
            else
            {
                if (m_bIsCathchObjHitTarget)
                {
                    //抓到的物体放在正确位置后绳子要回去
                    if (rope.restLength > m_ropeStartLength)
                    {
                        if(m_bControlPlayAudio)
                        {
                            m_bControlPlayAudio = false;
                            //GameServices.audioServices.PlayAudio(GameServices.configService.audioConfig.clawDownOrUp);
                            //PlayShake();
                        }
                        m_bIsClawUp = true;
                        PlayShake();
                        cursor.ChangeLength(rope.restLength - GameServices.configService.playerConfig.ropeReduceSpeed * Time.deltaTime);
                    }
                    else
                    {
                        //if (m_clawDownOrUpAudioSource)
                        //{
                        //    GameServices.audioServices.AudioPlayFinished(m_clawDownOrUpAudioSource);
                        //    m_clawDownOrUpAudioSource = null;
                        //}
                        m_bIsCatch = false;
                        m_bIsNeedRotate = true;
                        m_bIsCathchObjHitTarget = false;
                        ResetLightPos();
                        SetJoyStickDirectTrans(m_topCollider.transform);
                    }
                    m_addAngleSpeed -= Time.deltaTime * varRotateSpeed;
                    if (m_addAngleSpeed <= 0)
                    {
                        m_addAngleSpeed = 0;
                    }
                    m_leftClawTrans.localRotation = Quaternion.Euler(0, m_leftClawStartRatateY, -m_addAngleSpeed);
                    m_rightClawTrans.localRotation = Quaternion.Euler(0, m_rightClawStartRatateY, m_addAngleSpeed);
                }
                else
                {
                    if (rope.restLength > m_ropeStartLength)
                    {
                        if (m_bControlPlayAudio)
                        {
                            m_bControlPlayAudio = false;
                            //GameServices.audioServices.PlayAudio(GameServices.configService.audioConfig.clawDownOrUp);
                            //PlayShake();
                        }
                        m_bIsClawUp = true;
                        PlayShake();
                        cursor.ChangeLength(rope.restLength - GameServices.configService.playerConfig.ropeReduceSpeed * Time.deltaTime);
                    }
                    else
                    {
                        SetJoyStickDirectTrans(m_topCollider.transform);
                        //if (m_clawDownOrUpAudioSource)
                        //{
                        //    GameServices.audioServices.AudioPlayFinished(m_clawDownOrUpAudioSource);
                        //    m_clawDownOrUpAudioSource = null;
                        //}
                    }
                }
            }
            //方式1
            //if (rope.restLength > m_ropeStartLength)
            //{
            //    cursor.ChangeLength(rope.restLength - GameServices.configService.playerConfig.ropeReduceSpeed * Time.deltaTime);
            //}
            return;
        }
        if (rope.isLoaded)
        {
            if (m_bPress)
            {
                m_bIsClawUp = false;
                PlayShake();
                cursor.ChangeLength(rope.restLength + GameServices.configService.playerConfig.ropeExtendSpeed * Time.deltaTime);
            }
            if (m_bColliderTarget)
            {
                if (m_bIsMaxAngle)
                {
                    m_addAngleSpeed += Time.deltaTime * varRotateSpeed;
                    if (m_addAngleSpeed >= varMaxAngle)
                    {
                        m_addAngleSpeed = varMaxAngle;
                        m_bIsMaxAngle = false;
                    }
                }
                else
                {
                    //碰到物体之后爪子最小角度开始绳子缩回去
                    if (rope.restLength > m_ropeStartLength)
                    {
                        if (m_bControlPlayAudio)
                        {
                            m_bControlPlayAudio = false;
                            //GameServices.audioServices.PlayAudio(GameServices.configService.audioConfig.clawDownOrUp);
                            //PlayShake();
                        }
                        m_bIsClawUp = true;
                        PlayShake();
                        cursor.ChangeLength(rope.restLength - GameServices.configService.playerConfig.ropeReduceSpeed * Time.deltaTime);
                    }
                    else
                    {
                        //if (m_clawDownOrUpAudioSource)
                        //{
                        //    GameServices.audioServices.AudioPlayFinished(m_clawDownOrUpAudioSource);
                        //    m_clawDownOrUpAudioSource = null;
                        //}
                        m_bIsNeedRotate = true;
                        ResetLightPos();
                        SetJoyStickDirectTrans(m_topCollider.transform);
                    }
                    m_addAngleSpeed -= Time.deltaTime * varRotateSpeed;
                    if (m_addAngleSpeed <= 0)
                    {
                        m_addAngleSpeed = 0;
                    }
                }
                m_leftClawTrans.localRotation = Quaternion.Euler(0, m_leftClawStartRatateY, -m_addAngleSpeed);
                m_rightClawTrans.localRotation = Quaternion.Euler(0, m_rightClawStartRatateY, m_addAngleSpeed);
                //m_threeClawTrans.localRotation = Quaternion.Euler(0, m_threeClawStartRatateY, m_addAngleSpeed);
            }
            else
            {
                m_addAngleSpeed -= Time.deltaTime * varRotateSpeed;
                if (m_addAngleSpeed <= 0)
                {
                    m_addAngleSpeed = 0;
                }
                m_leftClawTrans.localRotation = Quaternion.Euler(0, m_leftClawStartRatateY, -m_addAngleSpeed);
                m_rightClawTrans.localRotation = Quaternion.Euler(0, m_rightClawStartRatateY, m_addAngleSpeed);
                //m_threeClawTrans.localRotation = Quaternion.Euler(0, m_threeClawStartRatateY, m_addAngleSpeed);
            }
        }
    }
    void LateUpdate()
    {
        if (!BattleCtrl.instance.isStartBattle)
        {
            return;
        }
        //开始爪身旋转
        //第五关特殊处理
        if (m_bIsNeedRotate)// && BattleCtrl.instance.levelManager.CurLevelIndex != LevelEnum.levelFiveIndex)
        {
            m_clawBodyAngleSpeed += Time.deltaTime * GameServices.configService.playerConfig.clawBodyRotateSpeed;
            m_clawBody.localRotation = Quaternion.Euler(0, m_clawBodyAngleSpeed, 0);
        }
        //爪子碰到地面也要回
        if (character.transform.position.y <= GameServices.configService.levelConfig.landPosY && !m_bColliderTarget)
        {
            m_bColliderTarget = true;
            m_bPress = false;
        }
        //抓住了
        if (m_bIsHitLeftClaw && m_bIsHitRightClaw && !m_bIsCatch
            && m_targetView && m_targetView.CanGetCatch() && m_addAngleSpeed >= m_targetView.clawMinAngle)
        {
            m_bIsCatch = true;
            m_bCatchTouchUp = false;
            m_targetView.DestroyRigidBody(m_rigidBody);
            //特殊处理
            if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelSixIndex)
            {
                onBalloonEnterTarget?.Invoke();
            }
        }
        //脱手了
        if(!m_bIsHitLeftClaw && !m_bIsHitRightClaw && m_bIsCatch && m_bControlUnHook)
        {
            m_bControlUnHook = false;
            m_lightObj.SetParent(m_clawBody.parent.parent);
            ClawUnHook();
        }
        //抓住的物体碰到地面也要回
        //if(m_bIsCatch && !m_bIsCathchObjHitTarget && m_targetView &&
        //    m_targetView.transform.position.y <= GameServices.configService.levelConfig.landPosY)
        //{
        //    TouchUpEnd();
        //}
    }
}
