﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class SixthLevelTrigger : MonoBehaviour
{
    public Collider m_collider;
    private Transform m_ballTrans;
    private Transform m_handleTrans;
    private bool m_bControl = true;
    private void Start()
    {
        m_handleTrans = BattleCtrl.instance.levelManager.curLevel.chainHandle.transform;
        m_ballTrans = BattleCtrl.instance.levelManager.curLevel.chainHandle.SteelBallTrans;
    }
    private void Update()
    {
        float varDis = Vector3.SqrMagnitude(m_ballTrans.position - m_handleTrans.position);
        if (varDis >= 20.0f && m_bControl)
        {
            m_bControl = false;
            m_collider.enabled = false;
            GameServices.timerServices.Push(this, 0.5f, delegate
            {
                m_bControl = true;
                m_collider.enabled = true;
            });
        }
    }
}
