﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class ChainHandle : MonoBehaviour
{
    private RectTransform m_thumbRT;//摇杆
    // Start is called before the first frame update
    private void Start()
    {
        GameServices.inputService.joyStick.onTouchStart.AddListener(OnTouchStart);
        GameServices.inputService.joyStick.onTouchUp.AddListener(OnTouchUp);
        SetJoyStickDirectTrans(transform);
        m_thumbRT = GameServices.inputService.joyStick.thumb;
    }
    //设置摇杆目标
    void SetJoyStickDirectTrans(Transform trans)
    {
        GameServices.inputService.joyStick.axisX.directTransform = trans;
        GameServices.inputService.joyStick.axisY.directTransform = trans;
    }
    void OnTouchStart()
    {
        float varX = (Input.mousePosition.x - Screen.width / 2f) / (Screen.width / GlobalConfig.NormalWidth);
        float varY = (Input.mousePosition.y - Screen.height / 2f)/ (Screen.width / GlobalConfig.NormalWidth);
        Vector2 varVec2 = GameServices.inputService.joyStick.gameObject.transform.localPosition;
        varVec2.x = varX;
        varVec2.y = varY;
        GameServices.inputService.joyStick.gameObject.transform.localPosition = varVec2;
        Vector2 varThumb = m_thumbRT.sizeDelta;
        varThumb.x = 80;
        varThumb.y = 80;
        m_thumbRT.sizeDelta = varThumb;
    }
    // 抬起回调
    void OnTouchUp()
    {
        if (!BattleCtrl.instance.isStartBattle)
        {
            return;
        }
        Vector2 varThumb = m_thumbRT.sizeDelta;
        varThumb.x = 4000;
        varThumb.y = 4000;
        m_thumbRT.sizeDelta = varThumb;
    }
        // Update is called once per frame
    void Update()
    {
    }
}
