﻿Shader "MyShader/PalneWorld"
{
    Properties
    {
        _MainTex ("Texture", 2D) = "white" {}
        _GetPos ("Start Pos(XYZ)",Vector)=(0,0,0,1)
        _Radius ("Radius", Float) = 0.5
        [Toggle]_Factor ("Factor", Int) = 1
    }
    SubShader
    {
        Tags { "RenderType"="Opaque" }
        LOD 100

        Pass
        {
            CGPROGRAM
            #pragma vertex vert
            #pragma fragment frag
            
            #include "UnityCG.cginc"
            
            struct appdata
            {
                float4 vertex : POSITION;
                float2 uv : TEXCOORD0;
            };
            
            struct v2f
            {
                float2 uv : TEXCOORD0;
                float4 vertex : SV_POSITION;
                float3 worldPos:TEXCOORD1;
            };
            
            sampler2D _MainTex;
            float4 _MainTex_ST;
            float3 _GetPos;
            float _Radius;
            int _Factor;
            
            v2f vert(appdata v)
            {
                v2f o;
                o.vertex = UnityObjectToClipPos(v.vertex);
                o.uv = TRANSFORM_TEX(v.uv, _MainTex);
                o.worldPos= mul(unity_ObjectToWorld,v.vertex).xyz;
                return o;
            }
            
            fixed4 frag(v2f i) : SV_Target
            {
                float dist=distance(i.worldPos,_GetPos);
                clip(dist-_Radius*_Factor);

                fixed4 col = tex2D(_MainTex, i.uv);
                return col;
            }
            ENDCG
        }
    }
}