﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class GroundCollision : MonoBehaviour
{
    private ChainRopeView m_chainRopeView;
    private void Start()
    {
        m_chainRopeView = BattleCtrl.instance.levelManager.curLevel.chainRopeView;
    }
    private void OnCollisionEnter(Collision other)
    {
        if (CanGetCatch(other) && m_chainRopeView.IsCatch && m_chainRopeView.CatchTouchUp)
        {
            m_chainRopeView.CatchObjEnterGround();
        }
    }
    bool CanGetCatch(Collision ohter)
    {
        return string.Equals(ohter.gameObject.name, GameServices.configService.levelConfig.firstLevelGoalName)
            || string.Equals(ohter.gameObject.name, GameServices.configService.levelConfig.secondLevelGoalName)
            || string.Equals(ohter.gameObject.name, GameServices.configService.levelConfig.thirdLevelGoalName)
            || string.Equals(ohter.gameObject.name, GameServices.configService.levelConfig.fourthLevelGoalName)
            || string.Equals(ohter.gameObject.name, "Claw");
    }
}
