﻿Shader "MyShader/EffectPalne2"
{
    Properties
    {
        _Scale("Main Texture Scale", Float) = 1 
        [NoScaleOffset]
        _MainTex ("Main Texture", 2D) = "white" {}
        _NoiseTex ("Distort Texture", 2D) = "white" {}
        _Strength ("Distort Strength", Range(-1,1)) = 0.5
        _SpeedX ("Speed X", Float) = 1
        _SpeedY ("Speed Y", Float) = 1
        _Radius ("Radius", Float) = 0.5
    }
    SubShader
    {
        Tags {"RenderType" = "Opaque"}
        LOD 100

        Pass
        {
            CGPROGRAM
            #pragma vertex vert
            #pragma fragment frag
            
            #include "UnityCG.cginc"
            
            struct appdata
            {
                float4 vertex : POSITION;
                float2 uv : TEXCOORD0;
            };
            
            struct v2f
            {
                float2 uv : TEXCOORD0;
                float4 vertex : SV_POSITION;
                float4 screenPos:TEXCOORD1;
            };
            
            sampler2D _MainTex;
            sampler2D _NoiseTex;
            half4 _NoiseTex_ST;
            half _Scale,_SpeedX,_SpeedY,_Strength;
            float _Radius;
            
            v2f vert(appdata v)
            {
                v2f o;
                o.vertex = UnityObjectToClipPos(v.vertex);
                o.uv = TRANSFORM_TEX(v.uv, _NoiseTex);
                o.screenPos=ComputeScreenPos(o.vertex);
            
                return o;
            }
            
            fixed4 frag(v2f i) : SV_Target
            {
                float dist=distance(i.uv,0.5);
                clip(_Radius-dist);

                half t=_Time.x;
                // sample the texture
                half2 scrUV=_Scale*i.screenPos.xy/i.screenPos.w;
                //scrUV+=noise;
                scrUV+=half2(_SpeedX,_SpeedY)*t;
                half2 noiseUV=scrUV*_NoiseTex_ST.xy+_NoiseTex_ST.zw;
                half2 noise=tex2D(_NoiseTex,noiseUV).rg*_Strength;
                scrUV+=noise;
                fixed4 col = tex2D(_MainTex,scrUV);
                return col;
            }
            ENDCG
        }
    }
}