﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class SixLevelPlayerCollision : MonoBehaviour
{
    public Transform m_topTrans;
    private bool m_bCollider = true;
    private bool m_bControlWin = true;
    private Animator m_animator;
    private float m_moveSpeed = 1.0f;
    private float m_minHeight = -2.0f;
    private float m_targetX = 1.06f;
    private float m_tartgetY = 2.0f;
    private Rigidbody m_playerRigid;
    private void Awake()
    {
        m_animator = GetComponent<Animator>();
        m_playerRigid = GetComponent<Rigidbody>();
    }
    private void OnCollisionEnter(Collision other)
    {
        if (other.collider.gameObject.CompareTag("Ball") && m_bCollider)
        {
            m_bCollider = false;
            BattleCtrl.instance.OnBattleFail();
        }
    }
    private void Update()
    {
        if (BattleCtrl.instance.isEndBattle)
        {
            return;
        }
        if (m_topTrans.localPosition.y <= 2.0f && m_bControlWin)
        {
            m_animator.Play("Run");
            if (transform.position.x < m_targetX)
            {
                transform.Translate(Vector3.right * Time.deltaTime * m_moveSpeed, Space.World);
            }
            else
            {
                m_playerRigid.isKinematic = true;
                transform.Translate(-Vector3.up * Time.deltaTime * m_moveSpeed, Space.World);
                if (transform.position.y <= m_tartgetY)
                {
                    m_bControlWin = false;
                    BattleCtrl.instance.OnBattleWin();
                }
            }
        }
    }
}
