﻿Shader "MyShader/Occlusion"
{
    Properties
    {
        _MainTex ("Texture", 2D) = "white" {}
    }
    SubShader
    {
        Tags {"RenderType" = "Transparent" "Queue"="Transparent" "DisableBatching" = "True"}
        LOD 100
        Cull Off
        
        Stencil
        {
            Ref 1
            Comp Always
            Pass Replace
        }

        GrabPass{"_ScreenTex"}

        Pass
        {
            Blend SrcAlpha OneMinusSrcAlpha
            CGPROGRAM
            #pragma vertex vert
            #pragma fragment frag
            
            #include "UnityCG.cginc"
            
            struct appdata
            {
                float4 vertex : POSITION;
                float2 uv : TEXCOORD0;
            };
            
            struct v2f
            {
                float2 uv : TEXCOORD0;
                float4 vertex : SV_POSITION;
                float4 grabPos:TEXCOORD1;
            };
            
            sampler2D _MainTex;
            sampler2D _ScreenTex;
            float4 _MainTex_ST;
            
            v2f vert(appdata v)
            {
                v2f o;
                o.vertex = UnityObjectToClipPos(v.vertex);
                o.uv = TRANSFORM_TEX(v.uv, _MainTex);
                o.grabPos=ComputeGrabScreenPos(o.vertex);
                return o;
            }
            
            fixed4 frag(v2f i) : SV_Target
            {
                // sample the texture
                fixed4 col = tex2Dproj(_ScreenTex,i.grabPos);
                //col.rgb=1-col.rgb;
                return col;
            }
            ENDCG
        }
    }
}
