﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.EventSystems;

public class BattleJoinPadEvent2 : MonoBehaviour, IPointerDownHandler, IDragHandler, IPointerUpHandler
{
    public BattleJoinPad joinPad;

    const int noPointerId = -100;

    /// <summary>
    /// 用于多点触控
    /// </summary>
    int m_PointerId = noPointerId;

    int m_PointerId2 = noPointerId;
    /// <summary>
    /// 位置记录
    /// </summary>
    Vector2 m_StartPos;
    float m_StartTime;
    Vector2 m_DragPos;

    public const int limitMax = 100;//100;
    public const int limitMin = 10;//10;

    Vector2 GetUGUIPosition(PointerEventData eventData)
    {
        Vector2 pos;
        RectTransformUtility.ScreenPointToLocalPointInRectangle(this.transform as RectTransform, eventData.position, eventData.pressEventCamera, out pos);
        return pos;
    }

    Vector2 GetUGUIPosition(Vector3 screenPos)
    {
        Vector2 pos;
        RectTransformUtility.ScreenPointToLocalPointInRectangle(this.transform as RectTransform, new Vector2(screenPos.x, screenPos.y), null, out pos);
        return pos;
        //return uiCamera.ScreenToViewportPoint(new Vector2(screenPos.x, screenPos.y));
    }

    void Awake()
    {
        if (this.joinPad == null)
        {
            this.joinPad = this.GetComponentInParent<BattleJoinPad>();
        }

        if (this.joinPad == null)
        {
            Debug.LogError("未发现BattleJoinPad");
        }
    }
    public void OnPointerDown(PointerEventData eventData)
    {
        //if (m_PointerId == noPointerId)
        //{
        //    // 标识为开始
        //    m_PointerId = eventData.pointerId;

        //    Vector2 startPosition = GetUGUIPosition(eventData);
        //    m_StartPos = startPosition;
        //    m_StartTime = Time.time;
        //    this.joinPad.SetPosition(startPosition);

        //    this.joinPad.OnFingerPointerDown();
        //}
        //else if (m_PointerId2 == noPointerId)
        //{
        //    m_PointerId2 = eventData.pointerId;
        //    this.joinPad.OnFinger2PointerDown();
        //}
        m_StartPos = eventData.position;
    }

    //帧同步使用，只有拖动时才改变方向，会出现间隔调用的情况，发送移动包
    public void OnDrag(PointerEventData eventData)
    {
        m_DragPos = eventData.position;
        Vector2 varVec2 = m_StartPos - m_DragPos;
        this.joinPad.SetBallOffset(varVec2);
        m_StartPos = m_DragPos;
        //if (m_PointerId == eventData.pointerId)
        //{
        //    Vector2 position = GetUGUIPosition(eventData);
        //    Vector2 offset = position - m_StartPos;

        //    // 范围限定
        //    float sqrMagnitude = offset.sqrMagnitude;
        //    if (sqrMagnitude > limitMax * limitMax)
        //    {
        //        offset = offset.normalized * limitMax;
        //    }
        //    else if (sqrMagnitude < limitMin * limitMin)
        //    {
        //        offset = Vector2.zero;
        //    }

        //    if (Time.time - m_StartTime > joinPad.JudgeMoveTime)
        //    {
        //        this.joinPad.SetBallOffset(offset);
        //    }
        //}
        m_StartPos = eventData.position;
    }

    public void OnPointerUp(PointerEventData eventData)
    {
        //if (m_PointerId == eventData.pointerId)
        //{
        //    // 标识为结束
        //    m_PointerId = noPointerId;

        //    this.joinPad.OnFingerTouchUp();
        //}
        //else if (m_PointerId2 == eventData.pointerId)
        //{
        //    // 标识为结束
        //    m_PointerId2 = noPointerId;

        //    this.joinPad.OnFinger2TouchUp();
        //}
        this.joinPad.OnFingerTouchUp();
        this.joinPad.ResetPosition(true);
    }

    public void ResetPointId()
    {
        m_PointerId = noPointerId;
    }

    void Update()
    {
        if (m_PointerId != noPointerId)
        {
#if UNITY_EDITOR
            Vector2 position = GetUGUIPosition(Input.mousePosition);
#else
            if (Input.touchCount <= 0)
                return;

            Vector2 position = GetUGUIPosition(Input.GetTouch(0).position);
#endif
            //Vector2 offset = position - m_StartPos;

            //// 范围限定
            //float sqrMagnitude = offset.sqrMagnitude;
            //if (sqrMagnitude > limitMax * limitMax)
            //{
            //    offset = offset.normalized * limitMax;
            //}
            //else if (sqrMagnitude < limitMin * limitMin)
            //{
            //    offset = Vector2.zero;
            //}

            //if (offset != Vector2.zero)
            //{
            //    if (Time.time - m_StartTime > joinPad.JudgeMoveTime)
            //    {
            //        this.joinPad.SetBallOffset(offset);
            //    }
            //}
        }
    }
}
