﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System;
#if UNITY_EDITOR
using UnityEditor;
#endif

public class BattleConfig : ScriptableObject
{
    public PlayerConfig playerConfig;
    public LevelConfig levelConfig;
    public AudioConfig audioConfig;


#if UNITY_EDITOR
    [MenuItem("Tools/Rope/生成战斗配置")]
    public static void GenBattleConfig()
    {
        string savePath = @"Assets/Resources/BattleConfig.asset";
        var data = ScriptableObject.CreateInstance("BattleConfig");
        AssetDatabase.CreateAsset(data, savePath);
    }
#endif

    /// <summary>
    /// 加载配置
    /// </summary>
    /// <returns></returns>
    public static BattleConfig LoadConfig()
    {
        return Resources.Load<BattleConfig>("BattleConfig");
    }
}

[Serializable]
public class PlayerConfig
{
    [Header("手移动的速度")]
    public float moveSpeed = 6;
    [Header("X方向最小距离")]
    public float xDirMinDis = -5;
    [Header("X方向最大距离")]
    public float xDirMaxDis = 5;
    [Header("Z方向最小距离")]
    public float yDirMinDis = -5;
    [Header("Z方向最大距离")]
    public float yDirMaxDis = 5;
    [Header("爪的最大角度")]
    public float clawMaxAngle = 30.0f;
    [Header("爪的旋转速度")]
    public float clawRotateSpeed = 20.0f;
    [Header("绳子缩减的速度")]
    public float ropeReduceSpeed = 2.0f;
    [Header("绳子伸长的速度")]
    public float ropeExtendSpeed = 3.0f;
    [Header("爪身的旋转速度")]
    public float clawBodyRotateSpeed = 2.0f;
    [Header("镜头移动速度")]
    public float cameraMoveSpeed = 2;
    [Header("镜头远近速度")]
    public float cameraFieldSpeed = 2;

    //爪子移动速度
    public float ClawMoveSpeed { get; set; }
    //铁球质量
    public float SteelBallMass { get; set; }
    //摇杆移动速度
    public float HandleMoveSpeed { get; set; }
}
[Serializable]
public class LevelConfig
{
    [Header("关卡3的地面位置")]
    public float landPosY = 1.9f;
    [Header("第一关目标名称")]
    public string firstLevelGoalName = "Tree_Star";
    [Header("第二关目标名称")]
    public string secondLevelGoalName = "Boy_01";
    [Header("第三关目标名称")]
    public string thirdLevelGoalName = "Boy_02";
    [Header("第四关目标名称")]
    public string fourthLevelGoalName = "SM_Prop_Crate_03 (2)";
    [Header("第五关目标名称")]
    public string fifthLevelGoalName1 = "BlueDark_BunnyBalloon";
    public string fifthLevelGoalName2 = "SM_Icon_Sword_01";
    public string fifthLevelGoalName3 = "SM_Primitive_Sphere_02";
    [Header("第六关目标名称")]
    public string sixthLevelGoalName = "SM_Primitive_Pyramid_01";
    [Header("第七关目标名称")]
    public string seventhLevelGoalName = "SM_Primitive_Cube_04 (1)";
}
[Serializable]
public class AudioConfig
{
    [Header("失败音效列表")]
    public List<AudioClip> failList;
    [Header("游戏bmg")]
    public AudioClip GameBgm;

    [Header("胜利")]
    public AudioClip Success;

    [Header("爪子下降或者上升")]
    public AudioClip clawDownOrUp;
    /// <summary>
    /// 获取随机一个失败叫声
    /// </summary>
    /// <returns></returns>
    public AudioClip GetFail()
    {
        int index =  UnityEngine.Random.Range(0, failList.Count);
        return failList[index];
    }
}
