﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
//using UnityEditor;
using Obi;

public class ChainHandle : MonoBehaviour
{
    public Rigidbody m_steelBallRigidBody;//铁球
    public Transform SteelBallTrans => m_steelBallRigidBody.transform;
    private RectTransform m_thumbRT;//摇杆
    private LevelEnum.MouseDirEnum m_mouseDir = LevelEnum.MouseDirEnum.Left;
    public LevelEnum.MouseDirEnum MouseDir => m_mouseDir;
    private Vector2 m_StartPos;
    private Vector2 m_DragPos;
    private Rigidbody m_rigidBody;//自身body
    private float m_topColliderPosY;//Y位置
    private Vector3 m_maxHeightBallPos = new Vector3(2.075f, 3.0f, -6.5f);//铁球最大高度
    private Transform m_parentTrans;//父节点
    private HingeJoint m_hingJoint;
    private bool m_controlRotate = true;//控制旋转
    // Start is called before the first frame update
    private void Awake()
    {
        m_rigidBody = gameObject.GetComponent<Rigidbody>();
        m_topColliderPosY = transform.position.y;
        m_parentTrans = transform.parent;
        m_hingJoint = gameObject.GetComponent<HingeJoint>();
        //Lightmapping.giWorkflowMode = Lightmapping.GIWorkflowMode.Legacy;
    }
    private void OnCollisionEnter(Collision other)
    {
        if (other.collider.gameObject.CompareTag("Ball"))
        {
            m_rigidBody.isKinematic = true;
        }
    }
    private void OnCollisionExit(Collision other)
    {
        if (other.collider.gameObject.CompareTag("Ball"))
        {
            m_rigidBody.isKinematic = false;
        }
    }
    private void Start()
    {
        GameServices.inputService.pad.onMoveVec3 += OnMove;
        GameServices.inputService.joyStick.onTouchStart.AddListener(OnTouchStart);
        GameServices.inputService.joyStick.onTouchUp.AddListener(OnTouchUp);
        BattleCtrl.instance.battleUI.onFieldFarBtn = onSteelBallAddMassBtn;
        BattleCtrl.instance.battleUI.onFieldNearBtn = onSteelBallDownMassBtn;
        SetJoyStickDirectTrans(transform);
        m_thumbRT = GameServices.inputService.joyStick.thumb;
        m_steelBallRigidBody.mass = GameServices.configService.playerConfig.SteelBallMass;
        //第六关特殊处理
        if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelSixIndex)
        {
            GameServices.inputService.joyStick.activated = false;
            m_steelBallRigidBody.mass = 5;
            BattleCtrl.instance.battleUI.SetSymbolPos(0, 0);
        }
        else
        {
            GameServices.inputService.joyStick.activated = true;
        }
    }
    void onSteelBallAddMassBtn()
    {
        GameServices.configService.playerConfig.SteelBallMass += Time.deltaTime;
        m_steelBallRigidBody.mass = GameServices.configService.playerConfig.SteelBallMass;
    }
    void onSteelBallDownMassBtn()
    {
        GameServices.configService.playerConfig.SteelBallMass -= Time.deltaTime;
        m_steelBallRigidBody.mass = GameServices.configService.playerConfig.SteelBallMass;
    }
    //设置摇杆目标
    public void SetJoyStickDirectTrans(Transform trans)
    {
        GameServices.inputService.joyStick.axisX.directTransform = trans;
        GameServices.inputService.joyStick.axisY.directTransform = trans;
    }
    void OnTouchStart()
    {
        float varX = (Input.mousePosition.x - Screen.width / 2f) / (Screen.width / GlobalConfig.NormalWidth);
        float varY = (Input.mousePosition.y - Screen.height / 2f)/ (Screen.width / GlobalConfig.NormalWidth);
        Vector2 varVec2 = GameServices.inputService.joyStick.gameObject.transform.localPosition;
        varVec2.x = varX;
        varVec2.y = varY;
        GameServices.inputService.joyStick.gameObject.transform.localPosition = varVec2;
        Vector2 varThumb = m_thumbRT.sizeDelta;
        varThumb.x = 80;
        varThumb.y = 80;
        m_thumbRT.sizeDelta = varThumb;
    }
    // 抬起回调
    void OnTouchUp()
    {
        if (!BattleCtrl.instance.isStartBattle)
        {
            return;
        }
        Vector2 varThumb = m_thumbRT.sizeDelta;
        varThumb.x = 4000;
        varThumb.y = 4000;
        m_thumbRT.sizeDelta = varThumb;
    }
    //移动
    void OnMove(Vector3 dir)
    {
        if (!BattleCtrl.instance.isStartBattle)
        {
            return;
        }
        //第五关特殊处理
        //if(BattleCtrl.instance.levelManager.CurLevelIndex != LevelEnum.levelFiveIndex)
        {
            m_rigidBody.drag = 10;
            m_rigidBody.angularDrag = 10;
        }
        float varParamDis = Screen.width * GameServices.configService.playerConfig.ClawMoveSpeed / 2;//参数距离
        Vector3 varPos = transform.position;
        //向左滑
        if (dir.x > 0)
        {
            varPos.x -= dir.x / varParamDis * GameServices.configService.playerConfig.xDirMaxDis;
        }
        //向右滑
        if (dir.x < 0)
        {
            varPos.x += dir.x / varParamDis * GameServices.configService.playerConfig.xDirMinDis;
        }
        //向上滑
        if (dir.y < 0)
        {
            varPos.z += dir.y / varParamDis * GameServices.configService.playerConfig.yDirMinDis;
        }
        //向下滑
        if (dir.y > 0)
        {
            varPos.z -= dir.y / varParamDis * GameServices.configService.playerConfig.yDirMaxDis;
        }
        varPos.y = m_topColliderPosY;
        transform.position = varPos;
    }
    private void OnDestroy()
    {
        if (GameServices.inputService != null)
        {
            GameServices.inputService.pad.onMoveVec3 -= OnMove;
        }
    }
    // Update is called once per frame
    void Update()
    {
        if (!BattleCtrl.instance.isStartBattle)
        {
            return;
        }
        if (Input.GetMouseButtonDown(0) && BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelSixIndex)
        {
            Clicked();
        }
        if (Input.GetMouseButton(0))
        {
            //float varX = Input.mousePosition.x - Screen.width / 2f;
            //float varY = Input.mousePosition.y - Screen.height / 2f;
            //BattleCtrl.instance.battleUI.SetMousePos(varX, varY);
            Vector3 varVec3 = Camera.main.WorldToScreenPoint(transform.position);
            varVec3.x = (varVec3.x - Screen.width / 2f) / (Screen.width / GlobalConfig.NormalWidth) + 50;
            varVec3.y = (varVec3.y - Screen.height / 2f) / (Screen.width / GlobalConfig.NormalWidth) - 50;
            BattleCtrl.instance.battleUI.SetMousePos(varVec3.x, varVec3.y);
        }
        else if (Input.GetMouseButtonUp(0))
        {
            BattleCtrl.instance.battleUI.SetMousePos(0, 0);
        }
        //if (Input.GetMouseButtonDown(0))
        //{
        //    m_StartPos = Input.mousePosition;
        //}
        //if(Input.GetMouseButton(0))
        //{
        //    m_DragPos = Input.mousePosition;
        //    Vector2 varVec2 = m_StartPos - m_DragPos;
        //    OnMove(varVec2);
        //    m_StartPos = m_DragPos;
        //}
        //第六关特殊处理
        //if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelSixIndex)
        //{
        //    float varMinX = GameServices.configService.playerConfig.xDirMinDis;
        //    float varMaxX = GameServices.configService.playerConfig.xDirMaxDis;
        //    float varMinY = GameServices.configService.playerConfig.yDirMinDis;
        //    float varMaxY = GameServices.configService.playerConfig.yDirMaxDis;
        //    transform.position = new Vector3(Mathf.Clamp(transform.position.x, varMinX, varMaxX),
        //                                           m_topColliderPosY,
        //                                           Mathf.Clamp(transform.position.z, varMinY, varMaxY));
        //}
        //铁球有去无回
        if(transform.localEulerAngles.x > 180.0f && m_controlRotate)
        {
            if (m_hingJoint)
            {
                GameObject.Destroy(m_hingJoint);
                m_hingJoint = null;
            }
            if (m_rigidBody)
            {
                GameObject.Destroy(m_rigidBody);
                m_rigidBody = null;
            }
            Quaternion varVec3 = transform.localRotation;
            varVec3.x -= Time.deltaTime/2;
            transform.localRotation = varVec3;
            if(transform.localEulerAngles.x <= 280.0f)
            {
                m_controlRotate = false;
            }
        }
    }

    void Clicked()
    {
        Ray ray = Camera.main.ScreenPointToRay(Input.mousePosition);

        RaycastHit hit = new RaycastHit();

        if (Physics.Raycast(ray, out hit))
        {
            if (hit.collider && hit.collider.gameObject.CompareTag("Target"))
            {
                //十字架位置
                float varX = (Input.mousePosition.x - Screen.width / 2f) / (Screen.width / GlobalConfig.NormalWidth);
                float varY = (Input.mousePosition.y - Screen.height / 2f) / (Screen.width / GlobalConfig.NormalWidth);
                BattleCtrl.instance.battleUI.SetSymbolPos(varX, varY);
                //重置状态
                if(m_rigidBody)
                {
                    m_rigidBody.isKinematic = true;
                }
                if(m_hingJoint)
                {
                    GameObject.Destroy(m_hingJoint);
                    m_hingJoint = null;
                }
                transform.localRotation = Quaternion.Euler(60,0,0);
                m_controlRotate = true;

                //设置铁球位置
                Vector3 varVec3 = m_parentTrans.position;
                varVec3.x = hit.point.x - m_maxHeightBallPos.x;
                varVec3.y = hit.point.y+5.7f;
                varVec3.z = 0;
                m_parentTrans.position = varVec3;
                GameServices.timerServices.Push(this, 0.1f, delegate
                {
                    if (!m_rigidBody)
                    {
                        m_rigidBody = gameObject.AddComponent<Rigidbody>();
                    }
                    if (!m_hingJoint)
                    {
                        m_hingJoint = gameObject.AddComponent<HingeJoint>();
                    }
                    if(m_rigidBody)
                    {
                        m_rigidBody.isKinematic = false;
                    }
                });
            }
        }
    }
}
