﻿//战斗控制器,战斗场景的入口脚本
//using JBTree;
//using Common;
using System;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Assertions;
//using Common.Anim;

public class BattleCtrl : MonoBehaviour
{
    GameServices _GameServices;
    /// <summary>
    /// 游戏服务器
    /// </summary>
    public GameServices gameServices => _GameServices;

    public BattleUI battleUI;
    //public HomeUI homeUI;

    /// <summary>
    /// 关卡管理器
    /// </summary>
    public LevelManager m_levelManager;
    public LevelManager levelManager => m_levelManager;

    /// <summary>
    /// 场景加载器
    /// </summary>
    //public SceneLoadAsync sceneLoad = new SceneLoadAsync();

    bool _Inited;
    public bool inited => _Inited;

    bool _IsStartBattle;
    public bool isStartBattle => _IsStartBattle;

    bool _IsEndBattle;
    public bool isEndBattle => _IsEndBattle;

    static BattleCtrl _Instance;
    public static BattleCtrl instance => _Instance;

    //缓存cube处理
    public GameObject m_cubeChildObj;
    Stack<GameObject> m_cubeObjStack = new Stack<GameObject>();
    List<GameObject> m_cubeObjList = new List<GameObject>();
    private List<Transform> m_cubeChildTransList = new List<Transform>();

    private void Awake()
    {
        _Instance = this;
        //Assert.IsNotNull(battleUI, "battleUI is null");
        InitServices();
        Init();
        for(int i = 0;i<m_cubeChildObj.transform.childCount;i++)
        {
            m_cubeChildTransList.Add(m_cubeChildObj.transform.GetChild(i));
        }
        for(int i = 0;i<5;i++)
        {
            GameObject varGo = GameObject.Instantiate(m_cubeChildObj);
            varGo.SetActive(false);
            m_cubeObjStack.Push(varGo);
            m_cubeObjList.Add(varGo);
        }
        //TinySauce.OnGameStarted();
    }

    void Start()
    {
        battleUI.onStartBtn = StartBattle;
    }

    void InitServices()
    {
        _GameServices = GameServices.Create();
        _GameServices.Init();
    }

    void Init()
    {
        //设置竖屏
        Screen.orientation = ScreenOrientation.Portrait;
        Screen.autorotateToPortrait = true;
        Screen.autorotateToPortraitUpsideDown = true;
        Screen.autorotateToLandscapeLeft = false;
        Screen.autorotateToLandscapeRight = false;
        //GameServices.inputService.DisableService();

        //预加载
        //ResourcesManager.PreLoad();

        //GameServices.audioServices.PlayBgm(GameServices.configService.audioConfig.GameBgm);

        m_levelManager.onBeforeLoadLevel += OnBeforeLoadLevel;

        m_levelManager.onAfterLoadLevel += OnAfterLoadLevel;

        LoadLevel(0);

        Application.targetFrameRate = 60;

        _Inited = true;
    }

    /// <summary>
    /// 开始战斗，点击了每个关卡的开始游戏按钮后调用
    /// </summary>
    void StartBattle()
    {
        _IsStartBattle = true;


        //if (curLevel.curLevelIndex == 0)//第一关，记录玩家选择的pien
        //{
        //    GlobalData.roleSelectData = homeUI.GetRoleSelectData();
        //    homeUI.gameObject.SetActive(false);
        //}

        //curLevel.OnStartBattle();
    }

    /// <summary>
    /// 战斗失败回调
    /// </summary>
    public void OnBattleFail()
    {
        _IsEndBattle = true;
        battleUI.OnBattleFail();
    }

    public void OnBattleWin()
    {
        _IsEndBattle = true;
        battleUI.OnBattleWin();
        int varCurTime = (int)levelManager.curLevel.bestTime;
        if(LocalRecord.HasKey(levelManager.CurLevelIndex.ToString()))
        {
            int varBestTime = LocalRecord.GetIntRecord(levelManager.CurLevelIndex.ToString());
            if (varCurTime < varBestTime)
            {
                LocalRecord.SetIntRecord(levelManager.CurLevelIndex.ToString(), varCurTime);
            }
        }
        else
        {
            LocalRecord.SetIntRecord(levelManager.CurLevelIndex.ToString(), varCurTime);
        }
        //curLevel.battleView.playerView.OnWin();
    }

    /// <summary>
    /// 加载关卡前调用
    /// </summary>
    public void OnBeforeLoadLevel()
    {
        //_IsStartBattle = false;
        _IsEndBattle = false;
        battleUI.OnBeforeLoadLevel();
        //GameServices.inputService.DisableService();
    }

    /// <summary>
    /// 加载关卡后调用
    /// </summary>
    public void OnAfterLoadLevel()
    {
        battleUI.OnAfterLoadLevel();
    }

    /// <summary>
    /// 加载关卡
    /// </summary>
    /// <param name="levelIndex"></param>
    void LoadLevel(int levelIndex)
    {
        m_levelManager.LoadLevel(levelIndex);
    }
    public void GetFromPool(Transform parent)
    {
        GameObject varGo = null;
        if (m_cubeObjStack.Count > 0)
        {
            varGo = m_cubeObjStack.Pop();
        }
        else
        {
            varGo = GameObject.Instantiate(m_cubeChildObj);
            m_cubeObjList.Add(varGo);
        }
        if(varGo)
        {
            varGo.transform.SetParent(parent, false);
            varGo.transform.localPosition = Vector3.zero;
            //for (int i = 0; i < varGo.transform.childCount; i++)
            //{
            //    varGo.transform.GetChild(i).GetComponent<Rigidbody>().mass = 0.1f;
            //    varGo.transform.GetChild(i).GetComponent<Rigidbody>().AddForce(Vector3.down * 20000000.0f, ForceMode.Force);
            //}
            varGo.SetActive(true);
            GameServices.timerServices.Push(this, 2.0f, delegate
            {
                if (varGo)
                {
                    BackToPool(varGo);
                }
            });
        }
    }
    public void BackToPool(GameObject go)
    {
        if(go)
        {
            go.transform.SetParent(null);
            for (int i = 0; i < go.transform.childCount; i++)
            {
                go.transform.GetChild(i).localPosition = m_cubeChildTransList[i].localPosition;
                go.transform.GetChild(i).localRotation = Quaternion.identity;
            }
            go.SetActive(false);
            if(m_cubeObjStack != null)
            {
                m_cubeObjStack.Push(go);
            }
        }
    }

    private void OnDestroy()
    {
        m_levelManager.onBeforeLoadLevel -= OnBeforeLoadLevel;
        m_levelManager.onAfterLoadLevel -= OnAfterLoadLevel;
        //battleUI.onStartBtn = null;
        _GameServices.OnDisponse();
        _GameServices = null;
        //m_levelManager.curLevel.OnDispose();
        //m_levelManager = null;
        //TinySauce.OnGameFinished(0);
        for(int i = 0;i< m_cubeObjList.Count;i++)
        {
            GameObject.Destroy(m_cubeObjList[i]);
        }
        m_cubeObjList.Clear();
        m_cubeObjList = null;
        m_cubeObjStack = null;
    }

}
