﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
//using UnityEditor;

public class ChainHandle : MonoBehaviour
{
    public Rigidbody m_steelBallRigidBody;//铁球
    public Transform SteelBallTrans => m_steelBallRigidBody.transform;
    private RectTransform m_thumbRT;//摇杆
    private LevelEnum.MouseDirEnum m_mouseDir = LevelEnum.MouseDirEnum.Left;
    public LevelEnum.MouseDirEnum MouseDir => m_mouseDir;
    private Vector2 m_StartPos;
    private Vector2 m_DragPos;
    // Start is called before the first frame update
    private void Awake()
    {
        //Lightmapping.giWorkflowMode = Lightmapping.GIWorkflowMode.Legacy;
    }
    private void Start()
    {
        GameServices.inputService.pad.onMoveVec3 += OnMove;
        GameServices.inputService.joyStick.onTouchStart.AddListener(OnTouchStart);
        GameServices.inputService.joyStick.onTouchUp.AddListener(OnTouchUp);
        BattleCtrl.instance.battleUI.onFieldFarBtn = onSteelBallAddMassBtn;
        BattleCtrl.instance.battleUI.onFieldNearBtn = onSteelBallDownMassBtn;
        SetJoyStickDirectTrans(transform);
        m_thumbRT = GameServices.inputService.joyStick.thumb;
        m_steelBallRigidBody.mass = GameServices.configService.playerConfig.SteelBallMass;
    }
    void onSteelBallAddMassBtn()
    {
        GameServices.configService.playerConfig.SteelBallMass += Time.deltaTime;
        m_steelBallRigidBody.mass = GameServices.configService.playerConfig.SteelBallMass;
    }
    void onSteelBallDownMassBtn()
    {
        GameServices.configService.playerConfig.SteelBallMass -= Time.deltaTime;
        m_steelBallRigidBody.mass = GameServices.configService.playerConfig.SteelBallMass;
    }
    //设置摇杆目标
    public void SetJoyStickDirectTrans(Transform trans)
    {
        GameServices.inputService.joyStick.axisX.directTransform = trans;
        GameServices.inputService.joyStick.axisY.directTransform = trans;
    }
    void OnTouchStart()
    {
        float varX = (Input.mousePosition.x - Screen.width / 2f) / (Screen.width / GlobalConfig.NormalWidth);
        float varY = (Input.mousePosition.y - Screen.height / 2f)/ (Screen.width / GlobalConfig.NormalWidth);
        Vector2 varVec2 = GameServices.inputService.joyStick.gameObject.transform.localPosition;
        varVec2.x = varX;
        varVec2.y = varY;
        GameServices.inputService.joyStick.gameObject.transform.localPosition = varVec2;
        Vector2 varThumb = m_thumbRT.sizeDelta;
        varThumb.x = 80;
        varThumb.y = 80;
        m_thumbRT.sizeDelta = varThumb;
    }
    // 抬起回调
    void OnTouchUp()
    {
        if (!BattleCtrl.instance.isStartBattle)
        {
            return;
        }
        Vector2 varThumb = m_thumbRT.sizeDelta;
        varThumb.x = 4000;
        varThumb.y = 4000;
        m_thumbRT.sizeDelta = varThumb;
    }
    //移动
    void OnMove(Vector3 dir)
    {
        //向左滑
        if (dir.x > 0)
        {
            m_mouseDir = LevelEnum.MouseDirEnum.Left;
        }
        //向右滑
        if (dir.x < 0)
        {
            m_mouseDir = LevelEnum.MouseDirEnum.Right;
        }
        //向上滑
        if (dir.y < 0)
        {
            m_mouseDir = LevelEnum.MouseDirEnum.Up;
        }
        //向下滑
        if (dir.y > 0)
        {
            m_mouseDir = LevelEnum.MouseDirEnum.Down;
        }
    }
    private void OnDestroy()
    {
        if (GameServices.inputService != null)
        {
            GameServices.inputService.pad.onMoveVec3 -= OnMove;
        }
    }
    // Update is called once per frame
    void Update()
    {
        if (!BattleCtrl.instance.isStartBattle)
        {
            return;
        }
        if (Input.GetMouseButton(0))
        {
            //float varX = Input.mousePosition.x - Screen.width / 2f;
            //float varY = Input.mousePosition.y - Screen.height / 2f;
            //BattleCtrl.instance.battleUI.SetMousePos(varX, varY);
            Vector3 varVec3 = Camera.main.WorldToScreenPoint(transform.position);
            varVec3.x = (varVec3.x - Screen.width / 2f) / (Screen.width / GlobalConfig.NormalWidth) + 50;
            varVec3.y = (varVec3.y - Screen.height / 2f) / (Screen.width / GlobalConfig.NormalWidth) - 50;
            BattleCtrl.instance.battleUI.SetMousePos(varVec3.x, varVec3.y);
        }
        else if (Input.GetMouseButtonUp(0))
        {
            BattleCtrl.instance.battleUI.SetMousePos(0, 0);
        }
        //if (Input.GetMouseButtonDown(0))
        //{
        //    m_StartPos = Input.mousePosition;
        //}
        //if(Input.GetMouseButton(0))
        //{
        //    m_DragPos = Input.mousePosition;
        //    Vector2 varVec2 = m_StartPos - m_DragPos;
        //    OnMove(varVec2);
        //    m_StartPos = m_DragPos;
        //}
        float varMinX = GameServices.configService.playerConfig.xDirMinDis;
        float varMaxX = GameServices.configService.playerConfig.xDirMaxDis;
        float varMinY = GameServices.configService.playerConfig.yDirMinDis;
        float varMaxY = GameServices.configService.playerConfig.yDirMaxDis;
        transform.position = new Vector3(Mathf.Clamp(transform.position.x, varMinX, varMaxX),
                                               Mathf.Clamp(transform.position.y, varMinY, varMaxY),
                                               0);

    }
}
