﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class TargetTrigger : MonoBehaviour
{
    public float m_speed = 0.1f;
    private Vector3 m_pos = new Vector3(-1.61f, 0.22f, 0);
    private Vector3 m_posLevelFive = new Vector3(-1.61f, 10.35f, 0);
    private Quaternion m_rotation = Quaternion.identity;
    private bool m_bControl = true;
    private Transform m_targetTrans;
    //private void OnTriggerEnter(Collider other)
    //{
    //    if (other.gameObject.CompareTag("Target") && m_bControl)
    //    {
    //        m_bControl = false;
    //        BattleCtrl.instance.OnBattleWin();
    //        BattleCtrl.instance.levelManager.curLevel.chainRopeView.CatchObjEnterTarget();
    //    }
    //}
    protected virtual void OnTriggerEnter(Collider collider)
    {
        Rigidbody rb = collider.GetComponent<Rigidbody>();
        if (collider.gameObject.CompareTag("Target") && m_bControl && rb)
        {
            m_bControl = false;
            m_targetTrans = collider.transform;
            rb.constraints = RigidbodyConstraints.FreezePositionX | RigidbodyConstraints.FreezePositionY | RigidbodyConstraints.FreezePositionZ |
                                              RigidbodyConstraints.FreezeRotationX | RigidbodyConstraints.FreezeRotationY;
            BattleCtrl.instance.OnBattleWin();
        }
    }
    private void Update()
    {
        if (!m_bControl && m_targetTrans)
        {
            if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelFiveIndex)
            {
                m_targetTrans.localPosition = Vector3.Lerp(m_targetTrans.localPosition, m_posLevelFive, m_speed);
            }
            else
            {
                m_targetTrans.localPosition = Vector3.Lerp(m_targetTrans.localPosition, m_pos, m_speed);
            }
        }
    }
}
