﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using RayFire;

public class BombView : MonoBehaviour
{
    public Transform m_cameraTrans;//相机
    public Transform m_rootTrans;//root节点
    public LineRenderer lineRenderer;//线段渲染器  
    //public GameObject m_bombParticleObj;//炸弹粒子

    private GameObject m_curBomb;//当前的炸弹
    private BombState1View m_bombStateView;//控制炸弹状态
    //private GameObject m_curBombEffect;//当前炸弹特效
    private bool m_bCanBePlace = true;//是否能放置炸弹
    private int m_totalChildNum = 0;//总数
    private bool m_bControlWin = true;//控制成功
    private bool m_bControlFail = true;//控制失败
    private float m_rate = 0.4f;//百分比
    private float m_rotateSpeed = 10.0f;//旋转速度
    private float m_curRotateAngle = 0.0f;//当前旋转角度
    private float m_lastRotateAngle = 0.0f;//之前的旋转角度
    private int m_TotalDamageNum = 0;//破坏数量
    private List<Transform> m_lstDamage = new List<Transform>();
    private Vector3 v0 = new Vector3(1.0f, 0.0f, 0.0f);
    private Vector3 v1 = new Vector3(0.0f, 1.0f, 0.0f);
    private int m_lineIndex = 0;//线计数
    private Vector2 m_lastInputPos = Vector2.zero;
    private Vector3 m_firstBombPos;//第一个炸弹位置
    private Vector3 m_secondBombPos;//第二个炸弹位置
    private bool m_bControlDoubleBomb = false;//控制第二个炸弹的位置
    private Vector3 m_recordSecondBombPos;//位置记录
    private void Awake()
    {
        m_totalChildNum = m_rootTrans.childCount - 1;
    }
    private void Start()
    {
        GameServices.inputService.pad.onMoveVec3 += OnMove;
        //if(BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelFourIndex)
        //{
        //    m_rate = 0.4f;
        //}
        //else if(BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelFiveIndex)
        //{
        //    m_rate = 0.5f;
        //}
        //else if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelSixIndex)
        //{
        //    m_rate = 0.7f;
        //}
        //else if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelThreeIndex)
        //{
        //    m_rate = 0.3f;
        //}
        //else
        //{
        //    m_rate = 0.2f;
        //}
        lineRenderer.startWidth = 0.05f;
        lineRenderer.endWidth = 0.05f;
    }
    //移动
    void OnMove(Vector3 dir)
    {
        if (!BattleCtrl.instance.isStartBattle)
        {
            return;
        }
        m_curRotateAngle = m_cameraTrans.localEulerAngles.y;
        m_curRotateAngle -= dir.x * Time.deltaTime* m_rotateSpeed;
        m_cameraTrans.localRotation = Quaternion.Euler(0, m_curRotateAngle, 0);
    }
    //设置炸弹
    void SetBomb(GameObject go)
    {
        //if(m_bombParticleObj)
        //{
        //    m_bombParticleObj.SetActive(false);
        //}

        m_curBomb = go;
        m_bombStateView = go.GetComponent<BombState1View>();
        m_bombStateView.SetBombModel();
        //if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelOneIndex)
        //{
        //    m_curBomb.range = 0.5f;
        //}
        //else if(BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelTwoIndex)
        //{
        //    m_curBomb.range = 1.5f;
        //}
        //m_bCanBePlace = false;
    }
    //播放动画
    public void PlayBombAni()
    {
        if(m_bombStateView)
        {
            m_bombStateView.PlayBombAni();
        }
    }
    //画线
    void DrawLine()
    {
        float varDis = Vector3.Distance(m_firstBombPos, m_secondBombPos);
        Vector3 varDir = (m_secondBombPos - m_firstBombPos).normalized;
        lineRenderer.positionCount = m_lineIndex + 1;
        lineRenderer.SetPosition(m_lineIndex, m_firstBombPos + varDir * m_lineIndex * (varDis / 4.0f));

        m_lineIndex++;
        if (m_lineIndex >= 5)
        {
            m_lineIndex = 0;
            CancelInvoke("DrawLine");
        }
    }
    //设置放置状态
    public void SetPlaceState(bool value)
    {
        m_bCanBePlace = value;
    }
    //开始炸
    public void StartBomb()
    {
        //m_curBombEffect = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.bombEffectObj);
        //m_curBombEffect.transform.position = m_curBomb.transform.position;
        //m_curBomb?.Explode(0);
        m_bombStateView.StartBomb();
        m_curBomb.SetActive(false);
        lineRenderer.positionCount = 0;
        //回收
        m_bombStateView.ClearState();
        PoolManager.Instance.ReturnObjectToPool(m_curBomb);
        //GameServices.timerServices.Push(this, 1.0f, delegate
        //{
        //    PoolManager.Instance.ReturnObjectToPool(m_curBombEffect);
        //});
        InvokeRepeating("CalculateDamageNum", 0.3f, 0.1f);
    }
    void CalculateDamageNum()
    {
        if (m_rootTrans)
        {
            for (int i = 1; i < m_rootTrans.childCount; i++)
            {
                Transform varTrans = m_rootTrans.GetChild(i);
                if (varTrans && varTrans.GetComponent<Rigidbody>() &&
                    varTrans.GetComponent<Rigidbody>().useGravity && !m_lstDamage.Contains(varTrans))
                {
                    m_TotalDamageNum++;
                    m_lstDamage.Add(varTrans);
                }
            }
        }
    }
    private void OnDestroy()
    {
        if(m_bombStateView)
        {
            m_bombStateView.ClearState();
        }
        if (m_curBomb)
        {
            PoolManager.Instance.ReturnObjectToPool(m_curBomb);
        }
        //if(m_curBombEffect)
        //{
        //    PoolManager.Instance.ReturnObjectToPool(m_curBombEffect);
        //}
        if (GameServices.inputService != null)
        {
            GameServices.inputService.pad.onMoveVec3 -= OnMove;
        }
        if(IsInvoking("CalculateDamageNum"))
        {
            CancelInvoke("CalculateDamageNum");
        }
        if (IsInvoking("DrawLine"))
        {
            CancelInvoke("DrawLine");
        }
        if (IsInvoking("TimeLimitStartBomb"))
        {
            CancelInvoke("TimeLimitStartBomb");
        }
        m_lstDamage.Clear();
        m_lstDamage = null;
    }
    private void Update()
    {
        if (!BattleCtrl.instance.isStartBattle || BattleCtrl.instance.isEndBattle
            || BattleCtrl.instance.battleUI.IsActivitySelectLevelUi)
        {
            return;
        }
        if (Input.GetMouseButton(0))
        {
            float varX = (Input.mousePosition.x - Screen.width / 2f) / (Screen.width / GlobalConfig.NormalWidth) + 100.0f;
            float varY = (Input.mousePosition.y - Screen.height / 2f) / (Screen.width / GlobalConfig.NormalWidth) - 120.0f;
            BattleCtrl.instance.battleUI.SetMousePos(varX, varY);
        }
        if (Input.GetMouseButtonUp(0))
        {
            BattleCtrl.instance.battleUI.SetMousePos(0, 0);
            if (m_lastRotateAngle == m_curRotateAngle)
            {
                Clicked();
            }
            m_lastRotateAngle = m_curRotateAngle;
        }
        BattleCtrl.instance.battleUI.SetProgress(m_TotalDamageNum / (float)m_totalChildNum);
        //Debug.LogError((m_rootTrans.childCount - 1) + "................." + m_totalChildNum);
        if(m_bControlWin)
        {
            if (BattleCtrl.instance.battleUI.IsLeftEmtryBomb && !BattleCtrl.instance.battleUI.IsBombButtonCanInteractable)
            {
                m_bControlWin = false;
                Invoke("CheckSuccess", 4);
            }
            if ((float)m_TotalDamageNum / m_totalChildNum >= 0.8f)
            {
                m_bControlWin = false;
                BattleCtrl.instance.levelManager.curLevel.star = 3;
                BattleCtrl.instance.OnBattleWin();
            }
        }
        //if(m_rootTrans.childCount <= m_totalChildNum* m_rate && m_bControlWin)
        //{
        //    m_bControlWin = false;
        //    BattleCtrl.instance.OnBattleWin();
        //}
        if (BattleCtrl.instance.battleUI.IsLeftEmtryBomb && !BattleCtrl.instance.battleUI.IsBombButtonCanInteractable
            && m_TotalDamageNum < m_totalChildNum * 0.6f && m_bControlFail)
        {
            m_bControlFail = false;
            Invoke("CheckFail", 4);
        }
    }
    //检查胜利
    void CheckSuccess()
    {
        if ((float)m_TotalDamageNum / m_totalChildNum >= 0.8f)
        {
            BattleCtrl.instance.levelManager.curLevel.star = 3;
            BattleCtrl.instance.OnBattleWin();
        }
        else if ((float)m_TotalDamageNum/ m_totalChildNum < 0.8f && (float)m_TotalDamageNum/ m_totalChildNum >= 0.7f)
        {
            BattleCtrl.instance.levelManager.curLevel.star = 2;
            BattleCtrl.instance.OnBattleWin();
        }
        else if ((float)m_TotalDamageNum / m_totalChildNum >= 0.6f && (float)m_TotalDamageNum/ m_totalChildNum < 0.7f)
        {
            BattleCtrl.instance.levelManager.curLevel.star = 1;
            BattleCtrl.instance.OnBattleWin();
        }
    }
    //检查是否失败
    void CheckFail()
    {
        if (BattleCtrl.instance.isEndBattle)
        {
            return;
        }
        BattleCtrl.instance.OnBattleFail();
    }

    void Clicked()
    {
        Ray ray = Camera.main.ScreenPointToRay(Input.mousePosition);

        RaycastHit hit = new RaycastHit();

        if (Physics.Raycast(ray, out hit))
        {
            if (hit.collider.tag == "Target" && m_bCanBePlace)
            {
                BattleCtrl.instance.battleUI.SetSelectUIState(false);
                //一个炸弹的
                m_bCanBePlace = false;
                GameObject go = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.rayfireBombObj);
                //go.transform.position = hit.point;
                SetBomb(go);
                m_bombStateView.SetBombModelPos(hit.point);
                m_lastInputPos = Input.mousePosition;
                Vector3 varVec3 = hit.point;
                varVec3.x += 0.1f;
                m_firstBombPos = varVec3;
                BattleCtrl.instance.battleUI.SetBomb();
                //两个炸弹的
                //if (!m_bControlDoubleBomb)
                //{
                //    GameObject go = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.rayfireBombObj);
                //    //go.transform.position = hit.point;
                //    SetBomb(go);
                //    m_bombStateView.SetBombModelPos(hit.point);
                //    m_lastInputPos = Input.mousePosition;
                //    Vector3 varVec3 = hit.point;
                //    varVec3.x += 0.1f;
                //    m_firstBombPos = varVec3;
                //    //是否生成double
                //    if (BattleCtrl.instance.battleUI.IsBombDouble)
                //    {
                //        RandomCreateAnotherBomb();
                //        m_bControlDoubleBomb = true;
                //    }
                //    else
                //    {
                //        m_bCanBePlace = false;
                //        BattleCtrl.instance.battleUI.SetBomb();
                //    }
                //}
                //else
                //{
                //    m_bControlDoubleBomb = false;
                //    m_bCanBePlace = false;
                //    BattleCtrl.instance.battleUI.SetBomb();//指定位置后开始炸
                //    m_bombStateView.SetUnrealBombModelPos(hit.point);
                //    m_bombStateView.StartShaderChange();
                //    InvokeRepeating("DrawLine", 0.1f, 0.3f);
                //    Vector3 varPoint = hit.point;
                //    varPoint.x += 0.1f;
                //    m_secondBombPos = varPoint;
                //    //指定后要取消判定
                //    if(IsInvoking("TimeLimitStartBomb"))
                //    {
                //        CancelInvoke("TimeLimitStartBomb");
                //    }
                //}
            }
        }
    }
    //范围随机生成一个炸弹
    //void RandomCreateAnotherBomb()
    //{
    //    Vector3 varVec3;
    //    float varRanX = Random.Range(m_lastInputPos.x - 300.0f, m_lastInputPos.x + 300.0f);
    //    float varRanY = Random.Range(m_lastInputPos.y - 300.0f, m_lastInputPos.y + 300.0f);
    //    varVec3.x = varRanX;
    //    varVec3.y = varRanY;
    //    varVec3.z = Input.mousePosition.z;

    //    Ray ray = Camera.main.ScreenPointToRay(varVec3);

    //    RaycastHit hit = new RaycastHit();

    //    if (Physics.Raycast(ray, out hit))
    //    {
    //        if (hit.collider.tag == "Target" && m_bCanBePlace)
    //        {
    //            m_bombStateView.SetUnrealBombModelPos(hit.point);
    //            m_bombStateView.SetUnrealBombModel();
    //            m_recordSecondBombPos = hit.point;
    //            Invoke("TimeLimitStartBomb", 5.0f);
    //        }
    //        else
    //        {
    //            RandomCreateAnotherBomb();
    //        }
    //    }
    //    else
    //    {
    //        RandomCreateAnotherBomb();
    //    }
    //}
    ////过5秒自己开始炸,如果玩家没有指定位置
    //void TimeLimitStartBomb()
    //{
    //    m_bControlDoubleBomb = false;
    //    m_bCanBePlace = false;
    //    BattleCtrl.instance.battleUI.SetBomb();//指定位置后开始炸
    //    m_bombStateView.StartShaderChange();
    //    InvokeRepeating("DrawLine", 0.1f, 0.3f);
    //    Vector3 varPoint = m_recordSecondBombPos;
    //    varPoint.x += 0.1f;
    //    m_secondBombPos = varPoint;
    //}
}
