﻿using System.Collections;
using System.Collections.Generic;

public class GlobalConfig 
{
    /// <summary>
    /// 是否开启手机震动
    /// </summary>
    public static bool isEnableShake = true;

    /// <summary>
    /// 是否开启音效
    /// </summary>
    public static bool isEnableSound = true;

    /// <summary>
    /// 是否开启bgm
    /// </summary>
    public static bool isEnableBgm = true;

    /// <summary>
    /// 语言类型
    /// </summary>
    public static LangeType langType;
    public static string VibrationKey = "VibrationKey";//震动Key
    public static string SoundKey = "SoundKey";//音效Key
    public static string BgmKey = "BgmKey";//音乐Key

    public static float NormalWidth = 1920;
    public static float NormalHeight = 1080f;
    public static float CurRatio = (float)UnityEngine.Screen.height / (float)UnityEngine.Screen.width;
    public static float NormalRatio = NormalHeight / NormalWidth;
    public static float Ratio = CurRatio / NormalRatio;


    //public static float CanvaUIScaleX = BattleCtrl.instance.battleUI.gameObject.transform.localScale.x;//uicanva适配大小

    public static string CoinReCordKey = "Coin";//金币key
    public static int PT_South => (int)PoleType.PT_South;
    public static int PT_North => (int)PoleType.PT_North;
    public static int PT_No => (int)PoleType.PT_No;
}

public enum LangeType
{
    Chinese,
    English
}
public enum PoleType
{
    PT_South = 1,
    PT_North = -1,
    PT_No = 0,
}
