﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using RayFire;
using DG.Tweening;

public class BombStateView : MonoBehaviour
{
    public GameObject m_realBombObj;//真实炸弹
    public GameObject m_unrealBombState1Obj;//虚拟炸弹状态1
    public MeshRenderer m_unrealBombState2MeshRender;//虚拟炸弹状态2shader参数变化
    public GameObject m_unrealBombState3Obj;//虚拟炸弹状态3
    public GameObject m_strengthRealBombObj;//加强真实炸弹
    public GameObject m_strengthUnrealBombState1Obj;//加强虚拟炸弹状态1
    public MeshRenderer m_strengthUnrealBombState2MeshRender;//加强虚拟炸弹状态2shader参数变化
    public GameObject m_strengthUnrealBombState3Obj;//加强虚拟炸弹状态3

    private string m_shaderFloatStr = "_DissolveValue";//shader参数
    private float m_shaderFloatValue = 0.0f;
    private Material m_curMat;
    private Transform m_unrealParent;
    private Transform m_strengthUnrealParent;
    private GameObject m_firstBombEffect;
    private GameObject m_secondBombEffect;
    private Vector3 m_firstBombPos;
    private Vector3 m_secondBombPos;
    private Sequence m_sqFirst;
    private void Awake()
    {
        m_unrealParent = m_unrealBombState1Obj.transform.parent;
        m_strengthUnrealParent = m_strengthUnrealBombState1Obj.transform.parent;
    }
    //爆破动画效果
    public void PlayBombAni()
    {
        if (BattleCtrl.instance.battleUI.IsBombStrength)
        {
            if (BattleCtrl.instance.battleUI.IsBombDouble)
            {
                m_sqFirst = DOTween.Sequence();
                m_sqFirst.Append(m_strengthRealBombObj.transform.DOScale(Vector3.one * 0.8f, 0.5f));
                m_sqFirst.Join(m_strengthUnrealParent.DOScale(Vector3.one * 0.8f, 0.5f));

                m_sqFirst.Append(m_strengthRealBombObj.transform.DOScale(Vector3.one * 1.2f, 0.5f));
                m_sqFirst.Join(m_strengthUnrealParent.DOScale(Vector3.one * 1.2f, 0.5f));

                m_sqFirst.Append(m_strengthRealBombObj.transform.DOScale(Vector3.one * 0.25f, 0.25f));
                m_sqFirst.Join(m_strengthUnrealParent.DOScale(Vector3.one * 0.25f, 0.25f));

                m_sqFirst.Append(m_strengthRealBombObj.transform.DOScale(Vector3.one * 2.0f, 0.25f));
                m_sqFirst.Join(m_strengthUnrealParent.DOScale(Vector3.one * 2.0f, 0.25f));

                m_sqFirst.AppendCallback(OverAniCB);

            }
            else
            {
                m_sqFirst = DOTween.Sequence();
                m_sqFirst.Append(m_strengthRealBombObj.transform.DOScale(Vector3.one * 0.8f, 0.5f));
                m_sqFirst.Append(m_strengthRealBombObj.transform.DOScale(Vector3.one * 1.2f, 0.5f));
                m_sqFirst.Append(m_strengthRealBombObj.transform.DOScale(Vector3.one * 0.25f, 0.25f));
                m_sqFirst.Append(m_strengthRealBombObj.transform.DOScale(Vector3.one * 2.0f, 0.25f));
                m_sqFirst.AppendCallback(OverAniCB);
            }
        }
        else
        {
            if (BattleCtrl.instance.battleUI.IsBombDouble)
            {
                m_sqFirst = DOTween.Sequence();
                m_sqFirst.Append(m_realBombObj.transform.DOScale(Vector3.one * 0.8f, 0.5f));
                m_sqFirst.Join(m_unrealParent.transform.DOScale(Vector3.one * 0.8f, 0.5f));

                m_sqFirst.Append(m_realBombObj.transform.DOScale(Vector3.one * 1.2f, 0.5f));
                m_sqFirst.Join(m_unrealParent.transform.DOScale(Vector3.one * 1.2f, 0.5f));

                m_sqFirst.Append(m_realBombObj.transform.DOScale(Vector3.one * 0.25f, 0.25f));
                m_sqFirst.Join(m_unrealParent.transform.DOScale(Vector3.one * 0.25f, 0.25f));

                m_sqFirst.Append(m_realBombObj.transform.DOScale(Vector3.one * 2.0f, 0.25f));
                m_sqFirst.Join(m_unrealParent.transform.DOScale(Vector3.one * 2.0f, 0.25f));

                m_sqFirst.AppendCallback(OverAniCB);
            }
            else
            {
                m_sqFirst = DOTween.Sequence();
                m_sqFirst.Append(m_realBombObj.transform.DOScale(Vector3.one * 0.8f, 0.5f));
                m_sqFirst.Append(m_realBombObj.transform.DOScale(Vector3.one * 1.2f, 0.5f));
                m_sqFirst.Append(m_realBombObj.transform.DOScale(Vector3.one * 0.25f, 0.25f));
                m_sqFirst.Append(m_realBombObj.transform.DOScale(Vector3.one * 2.0f, 0.25f));
                m_sqFirst.AppendCallback(OverAniCB);
            }
        }
    }
    //动画播放结束回调
    void OverAniCB()
    {
        BattleCtrl.instance.battleUI.OnClickBoomBtn();
        BattleCtrl.instance.battleUI.SetSelectUIState(true);
    }
    //开始爆破
    public void StartBomb()
    {
        if (BattleCtrl.instance.battleUI.IsBombStrength)
        {
            if(BattleCtrl.instance.battleUI.IsBombDouble)
            {
                //m_firstBombEffect = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.bombEffectObj);
                m_firstBombEffect.transform.position = m_firstBombPos;
                GameServices.timerServices.Push(this, 1.0f, delegate
                {
                    PoolManager.Instance.ReturnObjectToPool(m_firstBombEffect);
                });
                m_strengthRealBombObj.GetComponent<RayfireBomb>().Explode(0);
                m_strengthRealBombObj.SetActive(false);
                //m_secondBombEffect = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.bombEffectObj);
                m_secondBombEffect.transform.position = m_secondBombPos;
                GameServices.timerServices.Push(this, 1.0f, delegate
                {
                    PoolManager.Instance.ReturnObjectToPool(m_secondBombEffect);
                });
                m_strengthUnrealParent.GetComponent<RayfireBomb>().Explode(0);
                m_strengthUnrealParent.gameObject.SetActive(false);
            }
            else
            {
                //m_firstBombEffect = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.bombEffectObj);
                m_firstBombEffect.transform.position = m_firstBombPos;
                GameServices.timerServices.Push(this, 1.0f, delegate
                {
                    PoolManager.Instance.ReturnObjectToPool(m_firstBombEffect);
                });
                m_strengthRealBombObj.GetComponent<RayfireBomb>().Explode(0);
                m_strengthRealBombObj.SetActive(false);
            }
        }
        else 
        {
            if (BattleCtrl.instance.battleUI.IsBombDouble)
            {
                //m_firstBombEffect = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.bombEffectObj);
                m_firstBombEffect.transform.position = m_firstBombPos;
                GameServices.timerServices.Push(this, 1.0f, delegate
                {
                    PoolManager.Instance.ReturnObjectToPool(m_firstBombEffect);
                });
                m_realBombObj.GetComponent<RayfireBomb>().Explode(0);
                m_realBombObj.SetActive(false);
                //m_secondBombEffect = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.bombEffectObj);
                m_secondBombEffect.transform.position = m_secondBombPos;
                GameServices.timerServices.Push(this, 1.0f, delegate
                {
                    PoolManager.Instance.ReturnObjectToPool(m_secondBombEffect);
                });
                m_unrealParent.GetComponent<RayfireBomb>().Explode(0);
                m_unrealParent.gameObject.SetActive(false);
            }
            else
            {
                //m_firstBombEffect = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.bombEffectObj);
                m_firstBombEffect.transform.position = m_firstBombPos;
                GameServices.timerServices.Push(this, 1.0f, delegate
                {
                    PoolManager.Instance.ReturnObjectToPool(m_firstBombEffect);
                });
                m_realBombObj.GetComponent<RayfireBomb>().Explode(0);
                m_realBombObj.SetActive(false);
            }
        }
    }
    //设置模型
    public void SetBombModel()
    {
        if(BattleCtrl.instance.battleUI.IsBombStrength)
        {
            m_strengthRealBombObj.SetActive(true);
        }
        else
        {
            m_realBombObj.SetActive(true);
        }
    }
    //设置模型位置
    public void SetBombModelPos(Vector3 pos)
    {
        if (BattleCtrl.instance.battleUI.IsBombStrength)
        {
            m_strengthRealBombObj.transform.position = pos;
        }
        else
        {
            m_realBombObj.transform.position = pos;
        }
        m_firstBombPos = pos;
    }
    //设置虚拟模型
    public void SetUnrealBombModel()
    {
        if (BattleCtrl.instance.battleUI.IsBombStrength)
        {
            m_strengthUnrealBombState1Obj.SetActive(true);
            m_curMat = m_strengthUnrealBombState2MeshRender.material;
        }
        else
        {
            m_unrealBombState1Obj.SetActive(true);
            m_curMat = m_unrealBombState2MeshRender.material;
        }
    }
    //shader开始变化
    public void StartShaderChange()
    {
        InvokeRepeating("SetShaderChange", 1.0f, Time.deltaTime);
    }
    //shader参数变化
    void SetShaderChange()
    {
        m_shaderFloatValue += Time.deltaTime;
        if(m_curMat.GetFloat(m_shaderFloatStr) > 0.0f)
        {
            m_curMat.SetFloat(m_shaderFloatStr, 1.0f - m_shaderFloatValue);
        }
        else
        {
            if (BattleCtrl.instance.battleUI.IsBombStrength)
            {
                m_strengthUnrealBombState1Obj.SetActive(false);
                m_strengthUnrealBombState3Obj.SetActive(true);
            }
            else
            {
                m_unrealBombState1Obj.SetActive(false);
                m_unrealBombState3Obj.SetActive(true);
            }
            ClearInvoke();
            PlayBombAni();
        }
    }
    //设置虚拟模型位置
    public void SetUnrealBombModelPos(Vector3 pos)
    {
        if (BattleCtrl.instance.battleUI.IsBombStrength)
        {
            m_strengthUnrealParent.position = pos;
        }
        else
        {
            m_unrealParent.position = pos;
        }
        m_secondBombPos = pos;
    }
    //清除状态
    public void ClearState()
    {
        m_unrealParent.gameObject.SetActive(true);
        m_strengthUnrealParent.gameObject.SetActive(true);
        m_realBombObj.SetActive(false);
        m_unrealBombState1Obj.SetActive(false);
        m_unrealBombState2MeshRender.material.SetFloat(m_shaderFloatStr, 1.0f);
        m_unrealBombState3Obj.SetActive(false);
        m_strengthRealBombObj.SetActive(false);
        m_strengthUnrealBombState1Obj.SetActive(false);
        m_strengthUnrealBombState2MeshRender.material.SetFloat(m_shaderFloatStr, 1.0f);
        m_strengthUnrealBombState3Obj.SetActive(false);
        m_shaderFloatValue = 0.0f;
        m_strengthRealBombObj.transform.localScale = Vector3.one;
        m_strengthUnrealParent.localScale = Vector3.one;
        m_realBombObj.transform.localScale = Vector3.one;
        m_unrealParent.localScale = Vector3.one;
        m_sqFirst.Kill();
        ClearInvoke();
    }
    //清除invoke
    void ClearInvoke()
    {
        if (IsInvoking("SetShaderChange"))
        {
            CancelInvoke("SetShaderChange");
        }
    }
    private void OnDestroy()
    {
        ClearInvoke();
    }
}
