﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class BulletTypeEightView : MonoBehaviour
{
    private Transform[] m_bullletTrans;
    private List<Vector3> m_startPosList = new List<Vector3>();//初始位置
    private List<Quaternion> m_startRotationList = new List<Quaternion>();//初始位置
    // Start is called before the first frame update
    void Awake()
    {
        m_bullletTrans = transform.GetComponentsInChildren<Transform>();
        for (int i = 1; i < m_bullletTrans.Length; i++)
        {
            m_startPosList.Add(m_bullletTrans[i].localPosition);
            m_startRotationList.Add(m_bullletTrans[i].localRotation);
        }
    }
    //加载初始化
    public void Init()
    {
        for (int i = 1; i < m_bullletTrans.Length; i++)
        {
            BulletSouthView varSouth = m_bullletTrans[i].GetComponent<BulletSouthView>();
            if (varSouth)
            {
                varSouth.StartMove();
            }
            BulletNorthView varNorth = m_bullletTrans[i].GetComponent<BulletNorthView>();
            if (varNorth)
            {
                varNorth.StartMove();
            }
        }
        Invoke("Reset", 10.0f);
    }
    //重置状态
    private void Reset()
    {
        PoolManager.Instance.ReturnObjectToPool(gameObject);
        for (int i = 1; i < m_bullletTrans.Length; i++)
        {
            BulletSouthView varSouth = m_bullletTrans[i].GetComponent<BulletSouthView>();
            if (varSouth)
            {
                varSouth.ResetState();
            }
            BulletNorthView varNorth = m_bullletTrans[i].GetComponent<BulletNorthView>();
            if (varNorth)
            {
                varNorth.ResetState();
            }
            m_bullletTrans[i].localPosition = m_startPosList[i - 1];
            m_bullletTrans[i].localRotation = m_startRotationList[i - 1];
        }
    }
}
