﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class BulletSouthView : MonoBehaviour
{
    [Header("速度")]
    public float m_speed = 0.0f;
    [Header("旋转速度")]
    public float m_rotateSpeed = 0.0f;
    private bool m_bMove = false;
    private bool m_bControl = true;
    private Rigidbody m_rigidBody;
    private Transform m_bossTrans;
    // Start is called before the first frame update
    void Start()
    {
        m_rigidBody = GetComponent<Rigidbody>();
    }

    //开始移动
    public void StartMove(Transform bossTrans = null)
    {
        m_bMove = true;
        //做饭1
        //m_bossTrans = bossTrans;
        //m_bMove = true;
        //transform.SetParent(null);
    }
    //设置激活状态
    public void SetActiveState(bool value)
    {
        gameObject.SetActive(value);
        if (!value)
        {
            m_bMove = false;
        }
    }
    //重置状态
    public void ResetState()
    {
        m_bMove = false;
        gameObject.SetActive(true);
        m_bControl = true;
        m_rigidBody.isKinematic = true;
        //做法1
        //m_bMove = false;
        //gameObject.SetActive(true);
        //m_bControl = true;
        //m_rigidBody.isKinematic = true;
        //transform.SetParent(m_bossTrans);
    }
    // Update is called once per frame
    void Update()
    {
        if (BattleCtrl.instance.isEndBattle)
        {
            return;
        }
        if (m_bMove && m_bControl)
        {
            transform.position += (transform.forward) * Time.deltaTime * m_speed;
            //做法1
            //MagnetView varPlayer = BattleCtrl.instance.levelManager.curLevel.magnetView;
            //Vector3 varDir = varPlayer.transform.position - transform.position;
            //transform.position += (varDir.normalized) * Time.deltaTime * m_speed;
            //Vector3 varPos = transform.localPosition;
            //if (varPos.y < 0.48)
            //{
            //    varPos.y = 0.48f;
            //}
            //transform.localPosition = varPos;
        }
        UpdateMagnetPower();
    }

    //磁场作用
    void UpdateMagnetPower()
    {
        MagnetView varPlayer = BattleCtrl.instance.levelManager.curLevel.magnetView;
        Vector3 varDir = transform.position - varPlayer.transform.position;
        if (varPlayer && Vector3.SqrMagnitude(varDir) <= varPlayer.magnetRange * varPlayer.magnetRange && m_bMove)
        {
            if (varPlayer.isSouthPole)
            {
                m_bControl = false;
                m_rigidBody.isKinematic = false;
                m_rigidBody.AddForce((varDir.normalized) * varPlayer.magnetPower, ForceMode.VelocityChange);
                //做法1
                //m_bControl = false;
                //m_rigidBody.isKinematic = false;
                //transform.SetParent(null);
                //m_rigidBody.AddForce((varDir.normalized /*- Vector3.up*0.1f*/) * varPlayer.magnetPower, ForceMode.Impulse);
            }
            else
            {
                //做法1
                //if(Vector3.SqrMagnitude(varDir) > varPlayer.disBulletAttach * varPlayer.disBulletAttach)
                //{
                //    //m_rigidBody.AddForce(-varDir.normalized * varPlayer.magnetPower, ForceMode.Impulse);
                //}
                //else
                //{
                //    m_bControl = false;
                //    transform.SetParent(varPlayer.transform);
                //    transform.RotateAround(varPlayer.transform.position, -varPlayer.transform.up, Time.deltaTime * m_rotateSpeed);
                //}
            }
        }
    }
}
