﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class BulletDamageView : MonoBehaviour
{
    [Header("速度")]
    public float m_speed = 0.0f;
    private bool m_bMove = false;
    private Vector3 m_dir = Vector3.zero;//方向
    private Transform m_bossTrans;
    // Start is called before the first frame update
    void Start()
    {
        
    }

    //开始移动
    public void StartMove(Transform bossTrans)
    {
        m_bossTrans = bossTrans;
        m_bMove = true;
        MagnetView varPlayer = BattleCtrl.instance.levelManager.curLevel.magnetView;
        m_dir = varPlayer.transform.position - transform.position;
        transform.SetParent(null);
    }
    //设置激活状态
    public void SetActiveState(bool value)
    {
        gameObject.SetActive(value);
        if(!value)
        {
            m_bMove = false;
        }
    }
    //重置状态
    public void ResetState()
    {
        m_bMove = false;
        gameObject.SetActive(true);
        transform.SetParent(m_bossTrans);
    }
    // Update is called once per frame
    void Update()
    {
        if (BattleCtrl.instance.isEndBattle)
        {
            return;
        }
        if (m_bMove)
        {
            transform.position += (m_dir.normalized) * Time.deltaTime * m_speed;
            Vector3 varPos = transform.localPosition;
            if(varPos.y < 0.48)
            {
                varPos.y = 0.48f;
            }
            transform.localPosition = varPos;
            MagnetView varPlayer = BattleCtrl.instance.levelManager.curLevel.magnetView;
            if(Vector3.SqrMagnitude(varPlayer.transform.position - transform.position) >= 400)
            {
                SetActiveState(false);
            }
        }
    }
}
