﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class TriggerView : MonoBehaviour
{
    [Header("是否变换磁极")]
    public bool m_bIsChangePole = false;
    //[Header("是否开启循环")]
    //public bool m_bIsChangePoleLoop = false;
    //[Header("循环间隔")]
    //public float m_changePoleLoopTime = 0.0f;

    //[Header("是否变换磁力")]
    //[Space(30)]
    //public bool m_bIsChangePower = false;
    //[Header("磁力变化大小")]
    //public float m_powerChangeSize = 0.0f;
    //[Header("是否开启循环")]
    //public bool m_bIsChangePowerLoop = false;
    //[Header("循环间隔")]
    //public float m_changePowerLoopTime = 0.0f;

    [Header("是否变成陷阱")]
    [Space(30)]
    public bool m_bIsChangeToTrap = false;
    [Header("是否开启循环")]
    public bool m_bIsChangeToTrapLoop = false;
    [Header("循环间隔")]
    public float m_changeToTrapLoopTime = 0.0f;

    [Header("移动触发器")]
    [Space(30)]
    public bool m_bIsMoveTrigger = false;

    private bool m_bControlCollison = false;
    private bool m_bControlPole = true;
    private bool m_bControlPoleLoop = true;
    private bool m_bControlPower = true;
    private bool m_bControlPowerLoop = true;
    private bool m_bControlTrap = true;
    private bool m_bControlTrapLoop = true;
    private bool m_bControlMoveTrigger = true;
    private LargeMagnetView m_largeView;
    private SmallMagnetView m_smallView;
    private string m_strSetMagnetChange = "SetMagnetChange";
    private string m_strSetMagnetPower = "SetMagnetPower";
    private string m_strSetTrap = "SetTrap";
    // Start is called before the first frame update
    void Start()
    {
    }
    //关联重磁铁
    public void SetLargeAttach(LargeMagnetView view)
    {
        m_largeView = view;
    }
    //关联轻磁铁
    public void SetSmallAttach(SmallMagnetView view)
    {
        m_smallView = view;
    }
    private void OnCollisionEnter(Collision other)
    {
        if (other.collider.CompareTag("Player") && !m_bControlCollison)
        {
            m_bControlCollison = true;
        }
    }
    //设置磁极变换
    void SetMagnetChange()
    {
        if(m_largeView)
        {
            m_largeView.SetMagnetChange();
        }
        if (m_smallView)
        {
            m_smallView.SetMagnetChange();
        }
    }
    //设置磁力变化
    void SetMagnetPower()
    {
        //if (m_largeView)
        //{
        //    m_largeView.SetMagnetPower(m_powerChangeSize);
        //}
        //if (m_smallView)
        //{
        //    m_smallView.SetMagnetPower(m_powerChangeSize);
        //}
    }
    //设置陷阱状态
    void SetTrap()
    {
        if (m_largeView)
        {
            m_largeView.SetTrap();
        }
        if (m_smallView)
        {
            m_smallView.SetTrap();
        }
    }
    //移动触发器
    void SetMoveTrigger()
    {
        if (m_largeView)
        {
            m_largeView.SetMove();
        }
        if (m_smallView)
        {
            m_smallView.SetMove();
        }
    }
    // Update is called once per frame
    void Update()
    {
        if(m_bControlCollison)
        {
            //磁极变换
            if(m_bIsChangePole && m_bControlPole)
            {
                m_bControlPole = false;
                SetMagnetChange();
            }
            //if(m_bIsChangePoleLoop && m_bControlPoleLoop)
            //{
            //    m_bControlPoleLoop = false;
            //    InvokeRepeating(m_strSetMagnetChange, 0.2f, m_changePoleLoopTime);
            //}
            //磁力变化
            //if(m_bIsChangePower && m_bControlPower)
            //{
            //    m_bControlPower = false;
            //    SetMagnetPower();
            //}
            //if(m_bIsChangePowerLoop && m_bControlPowerLoop)
            //{
            //    m_bControlPowerLoop = false;
            //    InvokeRepeating(m_strSetMagnetPower, 0.2f, m_changePowerLoopTime);
            //}
            //陷阱
            if(m_bIsChangeToTrap && m_bControlTrap)
            {
                m_bControlTrap = false;
                SetTrap();
            }
            if(m_bIsChangeToTrapLoop && m_bControlTrapLoop)
            {
                m_bControlTrapLoop = false;
                InvokeRepeating(m_strSetTrap, 0.2f, m_changeToTrapLoopTime);
            }
            //移动触发器
            if(m_bIsMoveTrigger && m_bControlMoveTrigger)
            {
                m_bControlMoveTrigger = false;
                SetMoveTrigger();
            }
        }
    }
    private void OnDestroy()
    {
        if(IsInvoking(m_strSetMagnetChange))
        {
            CancelInvoke(m_strSetMagnetChange);
        }
        if (IsInvoking(m_strSetMagnetPower))
        {
            CancelInvoke(m_strSetMagnetPower);
        }
        if (IsInvoking(m_strSetTrap))
        {
            CancelInvoke(m_strSetTrap);
        }
    }
}
