﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System;

public class RecordPointView : MonoBehaviour
{
    private bool m_bControlCollison = false;
    private void OnTriggerEnter(Collider other)
    {
        if (other.CompareTag("Player") && !m_bControlCollison)
        {
            m_bControlCollison = true;
            Vector3 varPos = BattleCtrl.instance.levelManager.curLevel.magnetView.transform.position;
            string varStr = string.Format("{0:F1}*{1:F1}*{2:F1}", varPos.x, varPos.y, varPos.z);
            String varLevelKey = BattleCtrl.instance.levelManager.CurLevelIndex.ToString();
            if (LocalRecord.HasKey(varLevelKey))
            {
                string varCurRecord = LocalRecord.GetStringRecord(varLevelKey);
                float varX = Convert.ToSingle(varCurRecord.Split('*')[0]);
                if (varPos.x < varX)
                {
                    LocalRecord.SetStringRecord(varLevelKey, varStr);
                }
            }
            else
            {
                LocalRecord.SetStringRecord(varLevelKey, varStr);
            }
        }
    }
}
