﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class NpcView : MonoBehaviour
{
    private bool m_bShow = false;
    // Update is called once per frame
    void Update()
    {
        if (Input.GetMouseButtonUp(0))
        {
            Clicked();
        }
        if(m_bShow)
        {
            Vector3 varVec3 = Camera.main.WorldToScreenPoint(transform.position);
            varVec3.x = (varVec3.x - Screen.width / 2f) / (Screen.height / GlobalConfig.NormalHeight);
            varVec3.y = (varVec3.y - Screen.height / 2f) / (Screen.height / GlobalConfig.NormalHeight) + 250.0f;
            BattleCtrl.instance.battleUI.SetNpcDialogue(varVec3.x, varVec3.y);
        }
    }
    //点击npc对话
    void Clicked()
    {
        Ray ray = Camera.main.ScreenPointToRay(Input.mousePosition);

        RaycastHit hit = new RaycastHit();

        if (Physics.Raycast(ray, out hit))
        {
            if (hit.collider.CompareTag("Npc") && !m_bShow)
            {
                m_bShow = true;
            }
        }
    }
}
