﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using DG.Tweening;

public class MoveView : MonoBehaviour
{
    [Header("是否移动")]
    public bool m_isMove = false;
    [Header("移动点")]
    public Vector3[] m_movePoint;
    [Header("正向速度")]
    public float m_forwardSpeed = 0.0f;
    [Header("反向速度")]
    public float m_backSpeed = 0.0f;

    private bool m_bIsForWard = true;//是否正向运动，开始默认正向
    private Vector3 m_startPos = Vector3.zero;//开始的位置
    private int m_curIndex = 0;//当前路径节点
    private bool m_bControlFinishNode = false;//控制完成一个节点
    private void Start()
    {
        m_startPos = transform.position;
    }
    //延时处理
    void DelayHandle()
    {
        m_bControlFinishNode = false;
    }
    // Update is called once per frame
    void Update()
    {
        if(m_isMove)
        {
            if(m_bIsForWard)
            {
                Vector3 varDir = m_movePoint[m_curIndex] - transform.position;
                transform.position += varDir.normalized * Time.deltaTime * m_forwardSpeed;
                if(Vector3.SqrMagnitude(varDir) <= 0.2f && !m_bControlFinishNode)
                {
                    m_bControlFinishNode = true;
                    m_curIndex++;
                    Invoke("DelayHandle", 0.1f);
                    if(m_curIndex == m_movePoint.Length)
                    {
                        m_bIsForWard = false;
                    }
                }
            }
            else
            {
                Vector3 varDir = m_startPos - transform.position;
                transform.position += varDir.normalized * Time.deltaTime * m_backSpeed;
                if (Vector3.SqrMagnitude(varDir) <= 0.2f)
                {
                    m_bIsForWard = true;
                    m_curIndex = 0;
                }
            }
        }
    }
}
